<?php
/**
 * Copyright (C) 2009  Honghao Geng (genghonghao@gmail.com)
 * $Id: function.inc.php 355 2009-11-28 20:22:36Z genghonghao $
 */

if (!defined('IN_ADMIN')) {
    die("Hacking attempt");
}

// 获得APACHE版本
function get_http_server_version() {
    if (function_exists('apache_get_version')) {
        return apache_get_version() ? apache_get_version() : NULL;
    }
    return NULL;
}

// 获得MYSQL版本
function get_db_server_version() {
    global $db;
    return $db->get_mysql_version();
}

// 获得操作系统和PHP版本
function get_os_and_php_version() {
    return PHP_OS  . "&nbsp;/&nbsp;PHP v," . PHP_VERSION;
}

// 获得程序的版本
function get_smartgoon_version() {
   include_once  GEN_ROOT . 'smartgoon_version.php';
   return SMARTGOON_NAME . SMARTGOON_VERSION . SMARTGOON_TYPE  . SMARTGOON_RELEASE;
}

// 获得数据大小
function get_db_size() {
    global $db;
    $sizes = 0;
    $tabs = $db->result("SHOW TABLES");
    foreach($tabs AS $tab) {
        foreach($tab AS $t) {
           $size =  $db->result("SHOW TABLE STATUS LIKE '$t'") ;
           $sizes += $size[0]['Data_length'] + $size[0]['Index_length'];
        }
    }
    return format_size($sizes);
}

// 转换大小单位的工作
function format_size($size, $start_unit = NULL) {
    if ($start_unit === NULL) {
        $units = array('B', 'K', 'M', 'G', 'T');
    } else {
        $units = array('K', 'M', 'G', 'T');
    }
    $i = 0;
    while(($size/1024) >= 1) {
        $size = $size/1024;
        $i++;
    }
    return sprintf("%.1f",   $size) . $units[$i];
}

// 获得导出数据的头部
function get_export_header() {
    global $lang, $db, $db_name;
    $row = '-- ' . GEN_VERSION . GEN_LINE_BREAK;
    $row .= '-- ' . 'http://www.smartgoon.com' . GEN_LINE_BREAK;
    $row .= '-- ' . sprintf($lang['export_db_date'], date('Y'),date('m'),date('d'),date('H'),date('i'),date('s')) . GEN_LINE_BREAK;
    $row .= '-- ' . sprintf($lang['export_db_version'], $db->get_mysql_version()) . GEN_LINE_BREAK;
    $row .= '-- ' . sprintf($lang['export_db_phpversion'], phpversion()) . GEN_LINE_BREAK;
    $row .= '-- ' . GEN_LINE_BREAK;
    $row .= '-- ' . sprintf($lang['export_db_dbname'], $db_name) .GEN_LINE_BREAK;
    $row .= '-- ' . GEN_LINE_BREAK . GEN_LINE_BREAK . GEN_LINE_BREAK;
    $row .= '-- --------------------------------------------------------' .GEN_LINE_BREAK . GEN_LINE_BREAK . GEN_LINE_BREAK;
    return $row;
}

// 获得数据表结构
function get_table_structure($table) {
    global $db, $lang;

    $insert_line = '-- ' . GEN_LINE_BREAK;
    $insert_line .= '-- ' . sprintf($lang['export_db_dbstat'], $table) .GEN_LINE_BREAK;
    $insert_line .= '-- ' . GEN_LINE_BREAK . GEN_LINE_BREAK;

    $result = $db->result("SHOW CREATE TABLE $table");
    $result = str_replace('\t', GEN_LINE_BREAK, $result[0]['Create Table']);
    $insert_line .= preg_replace('/^CREATE TABLE/', 'CREATE TABLE IF NOT EXISTS', $result);
    return $insert_line . ';' . GEN_LINE_BREAK . GEN_LINE_BREAK;
}

// 获得数据表中的可导入数据
function get_table_data($table) {
    global $db, $lang;

    $query = $db->query("SELECT * FROM `$table`");
    $data_res = $db->fetch_array($query);
    $data_num = count($data_res);

    if ($data_num > 0) {
        $insert_line = '-- ' . GEN_LINE_BREAK;
        $insert_line .= '-- ' . sprintf($lang['export_db_dbdata'], $table) .GEN_LINE_BREAK;
        $insert_line .= '-- ' . GEN_LINE_BREAK . GEN_LINE_BREAK;
        $insert_line .= "INSERT INTO `$table` (";

        $fields = $db->fetch_field($query);
        $fields_num = count($fields);

        for($i = 0; $i < $fields_num; $i++) {
            if ($fields_num != $i+1) {
                $insert_line .= "`{$fields[$i]}`, ";
            } else {
                $insert_line .= "`{$fields[$i]}`) VALUES" . GEN_LINE_BREAK;
            }
        }

        $data_row = '';

        for($j = 0; $j < $data_num; $j++) {
            foreach($data_res[$j] AS $val) {
                $data_row .= "'$val', ";
            }

            $data_row = "(" . substr($data_row, 0, -2) . ")," . GEN_LINE_BREAK;
            $insert_line .= $data_row;
            $data_row = '';
        }

        $insert_line = substr($insert_line, 0, -3) . ";" . GEN_LINE_BREAK . GEN_LINE_BREAK;
    } else {
        $insert_line = '-- ' . GEN_LINE_BREAK;
        $insert_line .= '-- ' . sprintf($lang['export_db_dbdata'], $table) .GEN_LINE_BREAK;
        $insert_line .= '-- ' . GEN_LINE_BREAK . GEN_LINE_BREAK;
        $insert_line .=  '-- --------------------------------------------------------' .GEN_LINE_BREAK . GEN_LINE_BREAK;
    }
    return $insert_line;
}

// 获得导航
function get_navigation() {
    global $menu, $lang;

    $navigation = array();
    foreach($menu AS $key=>$val) {
        if (!array_key_exists($key, $navigation)) {
            $navigation[$key]['url'] = '?module=' . $key;
            $navigation[$key]['name'] = $lang[$key]['name'];
        }
    }
    return $navigation;
}

// 获得当前导航下的分类
function get_cur_nav_category($nav_key) {
    global $menu, $lang;

    $category = array();
    if (isset($menu[$nav_key]) && is_array($menu[$nav_key])) {
        foreach($menu[$nav_key] as $key=>$val) {
            if ($key !== 'name') {
                $arr['name'] = isset($lang[$nav_key][$key]) ? $lang[$nav_key][$key] : $lang['not_found_lang'];
                $arr['url']  = $menu[$nav_key][$key];

                $category[] = $arr;
                unset($arr);
            }
        }
        return $category;
    }
    return $category;
}

// 页面跳转
function redirect($state_text, $msg, $url, $interval=5, $height=NULL) {
    global $base_url;
    if ($height !== NULL) {
        $height = "&height=" . $height;
    }
    $reload = $base_url . '/reload.php' . '?url=' . urlencode($url) . '&interval=' . $interval . '&msg=' . urlencode($msg) . '&state_text=' . urlencode($state_text) . $height;
    header("Location: $reload");
    exit;
}

// 获得系统中所有的可以使用的模板
function get_tpl_list() {
    $tpl_root = GEN_ROOT . 'templates';
    $tpls = array();
    $dh = opendir($tpl_root);
    if ($dh) {
        while (($file = readdir($dh)) !== false) {
            if (is_dir($tpl_root . '/' . $file) && substr($file, 0, 1) != '.') {
                $tpls[] = $file;
            }
        }
        closedir($dh);
    }
    return $tpls;
}

// 获取单个模板的详细数据
function get_tpl_info($tpl) {
    global $base_root_url;
    $tpl_path = GEN_ROOT . 'templates/' . $tpl;
    $tpls = array();
    $dh = opendir($tpl_path);
    if ($dh) {
        while (($file = readdir($dh)) !== false) {
            if (substr($file, 0, 6) == 'layout') {
                $tpls['img'] = $base_root_url . '/templates/' . $tpl . '/' . $file;
            }
            if ($file == 'template.ini') {
                $tmp = @file(GEN_ROOT . 'templates/' . $tpl . '/' . $file);
                if (is_array($tmp)) {
                    foreach($tmp AS $val) {
                        $tpls[substr($val, 0, strpos($val, ':'))] = trim(substr($val, strpos($val, ':')+1));
                    }
                }
            }
        }
        closedir($dh);
    }
    return $tpls;
}

/**
 * 系统提示信息
 *
 * @access      public
 * @param       string      msg_detail      消息内容
 * @param       int         msg_type        消息类型， 0消息，1错误，2询问
 * @param       array       links           可选的链接
 * @param       boolen      $auto_redirect  是否需要自动跳转
 * @return      void
 */
function sys_msg($msg_detail, $msg_type = 0, $links = array(), $auto_redirect = true) {
    global $lang, $tpl;
    if (count($links) == 0) {
        $links[0]['text'] = $lang['go_back'];
        $links[0]['href'] = 'javascript:history.go(-1)';
    }

    $tpl->assign('ur_here',     $lang['system_message']);
    $tpl->assign('msg_detail',  $msg_detail);
    $tpl->assign('msg_type',    $msg_type);
    $tpl->assign('links',       $links);
    $tpl->assign('default_url', $links[0]['href']);
    $tpl->assign('auto_redirect', $auto_redirect);

    $tpl->display('message.html');

    exit;
}

?>
