<?php
/**
 * Copyright (C) 2009  Honghao Geng (genghonghao@gmail.com)
 * $Id: transport.php 433 2009-12-13 12:46:22Z genghonghao $
 */

define('IN_ADMIN', TRUE);

header("Content-Type:text/html;charset=UTF-8");

require_once dirname(__FILE__) . '/init.php';
require_once GEN_ROOT . '/languages/' . $_CONF['lang'] . '/admin/transport.lang.php';

// 验证用户是否登录
if (false === verify_user()) {;
    header("Location: ../login.php");
}

// 获得当前页面的完整URL
$current_page_url = $base_url . '/' . $current_file . '?' . get_uri_param_string();

// 获得当前的动作
$action = isset($_REQUEST['act']) ? trim($_REQUEST['act']) : NULL;

$result = array();
// 清除缓存
if ($action == 'clear_cache') {
// 更新缓存
    $cache->set('conf');
    $cache-> destroy();
    $result['status'] = $lang['json_clear_cache_success'];
    echo json_encode($result);
}

// 添加分类
elseif ($action == 'add_cate') {
    $cate = isset($_REQUEST['val']) ? (trim($_REQUEST['val']) == NULL ? NULL : trim($_REQUEST['val'])) : NULL;
    if ($cate !== NULL) {
        $sql = "INSERT INTO " . $db->get_table(TB_CATEGORY) . " VALUES(NULL, '$cate')";
        if ($db->query($sql, '', 1) === false) {
            echo 'error';
        } else {
            echo $db->insert_id() . ',' . $cate;
        }
    } else {
        echo  $lang['alert_cate_not_null'];
    }
    exit;
}
// 添加标签
elseif ($action == 'add_tag') {
    $tag = isset($_REQUEST['val']) ? (trim($_REQUEST['val']) == NULL ? NULL : trim($_REQUEST['val'])) : NULL;
    if ($tag !== NULL) {
        $sql = "INSERT INTO " . $db->get_table(TB_TAGS) . " VALUES(NULL, '$tag')";
        if ($db->query($sql, '', 1) === false) {
            echo 'error';
        } else {
            echo $db->insert_id() . ',' . $tag;
        }
    } else {
        echo $lang['alert_tag_not_null'];
    }
    exit;
}

// 修改链接排序
elseif ($action == 'edit_link') {
    $id = isset($_REQUEST['id']) ? (trim($_REQUEST['id']) == NULL ? NULL : trim($_REQUEST['id'])) : NULL;
    $val = isset($_REQUEST['val']) ? (trim($_REQUEST['val']) == NULL ? NULL : trim($_REQUEST['val'])) : NULL;
    $sql = "UPDATE " . $db->get_table(TB_LINKS) . " SET link_order='$val' WHERE link_id='$id'";
    if ($db->query($sql, '', 1) === false) {
        echo 'Failure';
    } else {
        echo 'Success';
    }
    exit;
}
// 更新标题状态
elseif ($action == 'title') {
    $change_val = isset($_REQUEST['val']) ? trim($_REQUEST['val']) : NULL;
    if ($change_val === NULL) {
        die('Failure1') ;
    }
    if ($db->query("UPDATE " . $db->get_table(TB_CONF) . " SET conf_value='$change_val' WHERE conf_name='site_title'" , '', 1) === false) {
        die('Failure2');
    } else {
        die('Success!');
    }
}

// 编辑后台评论
elseif ($action == 'edit_comment') {
    $reply_id = isset($_REQUEST['reply_id']) ? intval($_REQUEST['reply_id']) : NULL;
    $reply_comment = isset($_REQUEST['reply_content']) ? trim($_REQUEST['reply_content']) : NULL;
    if (NULL === $reply_id) {
        $result['error'] = $lang['json_error_code'];
    }
    if (NULL === $reply_comment) {
        $result['error'] = $lang['json_error_code'];
    }

    $admin_id = $_SESSION['user']['userid'];
    $admin_name = $_SESSION['user']['username'];
    $cur_time = time();
    if (!isset($result['error'])) {
        $query = $db->query("UPDATE " . $db->get_table(TB_REPLY) . "
                                    SET admin_reply_content = '$reply_comment',
                                        admin_user_id = '$admin_id',
                                        admin_user_name = '$admin_name',
                                        admin_last_change_time = '$cur_time'
                                    WHERE reply_id = '$reply_id'
            ");

        if (false !== $query) {
            $result['status'] = $lang['json_success'];
        } else {
            $result['status'] = $lang['json_failure'];
        }
    } else {
    }
    echo json_encode($result);
}

// 更改评论审核状态
elseif ($action == 'change_comment_status') {
    $reply_id = isset($_REQUEST['reply_id']) ? intval($_REQUEST['reply_id']) : NULL;
    $is_auth  = isset($_REQUEST['is_auth']) ?  intval($_REQUEST['is_auth']) : NULL;
    if (NULL === $reply_id) {
        $result['error'] = $lang['json_error_code'];
    }
    if (NULL === $is_auth) {
        $result['error'] = $lang['json_error_code'];
    }

    $admin_id = $_SESSION['user']['userid'];
    $admin_name = $_SESSION['user']['username'];
    $cur_time = time();
    if (!isset($result['error'])) {
        $query = $db->query("UPDATE " . $db->get_table(TB_REPLY) . "
                                    SET is_auth = '$is_auth',
                                        admin_user_id = '$admin_id',
                                        admin_user_name = '$admin_name',
                                        admin_last_change_time = '$cur_time'
                                    WHERE reply_id = '$reply_id'
            ");

        if (false !== $query) {
            $result['status'] = $lang['json_success'];
            $result['reply_id'] = $reply_id;
            $result['is_auth'] = $is_auth;
        } else {
            $result['status'] = $lang['json_failure'];
        }
    } else {
    }
    echo json_encode($result);
}

// 修改导航
elseif ($action == 'edit_nav') {
    $nav_id   = intval($_REQUEST['view_id']);

    // 修改导航的排序
    if (isset($_REQUEST['order'])) {
        $notice_id = 'order'.$nav_id;
        $order_val = intval($_REQUEST['order']);
        $query = $db->query("UPDATE " . $db->get_table(TB_NAVIGATION) . "
                                    SET display_order = '$order_val'
                                    WHERE nav_id = '$nav_id'
            ");

        if (false !== $query) {
            $result['status'] = 1;
        } else {
            $result['status'] = 0;
        }
        $result['notice_id'] = $notice_id;
        echo json_encode($result);
        exit;
    }

    // 修改导航的名称
    if (isset($_REQUEST['name'])) {
        $notice_id = 'name'.$nav_id;
        $name_val = urldecode(trim($_REQUEST['name']));
        $query = $db->query("UPDATE " . $db->get_table(TB_NAVIGATION) . "
                                    SET nav_name = '$name_val'
                                    WHERE nav_id = '$nav_id'
            ");

        if (false !== $query) {
            $result['status'] = 1;
        } else {
            $result['status'] = 0;
        }
        $result['notice_id'] = $notice_id;
        echo json_encode($result);
        exit;
    }

    // 修改导航的URL
    if (isset($_REQUEST['url'])) {
        $notice_id = 'url'.$nav_id;
        $url_val = urldecode(trim($_REQUEST['url']));
        $query = $db->query("UPDATE " . $db->get_table(TB_NAVIGATION) . "
                                    SET nav_url = '$url_val'
                                    WHERE nav_id = '$nav_id'
            ");

        if (false !== $query) {
            $result['status'] = 1;
        } else {
            $result['status'] = 0;
        }
        $result['notice_id'] = $notice_id;
        echo json_encode($result);
        exit;
    }

    // 修改导航是否被开启
    if (isset($_REQUEST['unlock'])) {
        $notice_id = 'unlock'.$nav_id;
        $unlock_val = urldecode(trim($_REQUEST['unlock']));
        $query = $db->query("UPDATE " . $db->get_table(TB_NAVIGATION) . "
                                    SET is_unlock = '$unlock_val'
                                    WHERE nav_id = '$nav_id'
            ");

        if (false !== $query) {
            $result['status'] = 1;
        } else {
            $result['status'] = 0;
        }
        $result['notice_id'] = $notice_id;
        echo json_encode($result);
        exit;
    }

    // 修改导航链接的跳转方式
    if (isset($_REQUEST['target'])) {
        $notice_id = 'target'.$nav_id;
        $target_val = urldecode(trim($_REQUEST['target']));
        $query = $db->query("UPDATE " . $db->get_table(TB_NAVIGATION) . "
                                    SET target_type = '$target_val'
                                    WHERE nav_id = '$nav_id'
            ");

        if (false !== $query) {
            $result['status'] = 1;
        } else {
            $result['status'] = 0;
        }
        $result['notice_id'] = $notice_id;
        echo json_encode($result);
        exit;
    }
}
?>