<?php
/**
 * Copyright (C) 2009  Honghao Geng (genghonghao@gmail.com)
 * $Id: common.inc.php 583 2010-07-31 19:03:22Z genghonghao $
 */
// 初始化设置

substr(PHP_VERSION, 0,3) < 5.3 ? set_magic_quotes_runtime(0) : null;
ignore_user_abort(true);
@ini_set('register_long_arrays', 'Off');
@ini_set('memory_limit',          '64M');
@ini_set('session.cache_expire',  1800);
@ini_set('session.use_trans_sid', 0);
@ini_set('session.use_cookies',   1);
@ini_set('session.auto_start',    0);

// 设置根目录
define('GEN_ROOT', substr(dirname(__FILE__), 0, -8));

require GEN_ROOT . '/data/config.inc.php';

// 是否是调试模式
if (isset($is_debug) && $is_debug == true) {
    error_reporting(E_ALL);
    ini_set('display_errors', 'On');
} else {
    error_reporting(E_NOTICE);
    ini_set('display_errors', 'Off');
}

// 谷歌的问题
if(isset($_SERVER['HTTP_X_MOZ']) && $_SERVER['HTTP_X_MOZ'] == 'prefetch') {
    header('HTTP/1.1 403 Prefetching Forbidden');
    header('Expires: Thu, 21 Jul 1997 07:30:00 GMT');
    header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
    header('Cache-Control: post-check=0, pre-check=0', false);
    header('Pragma: no-cache');
    exit();
}

// 判断调用当前文件的文件是否合法
if (!defined('IN_GEN') ) {
    die("Hacking attempt");
}

// 不允许被提交的数据
if(isset($_POST['GLOBALS']) || isset($_FILES['GLOBALS']) || isset($_GET['GLOBALS']) || isset($_COOKIE['GLOBALS'])) {
    die("Hacking attempt");
}

// 检测SESSION是否存在和合法
if (isset($_SESSION) && !is_array($_SESSION)) {
    die("Hacking attempt");
}

// 关闭register_globals选择
if (@ini_get('register_globals') == '1' || strtolower(@ini_get('register_globals')) == 'on') {
    @ini_set('register_globals', 'Off');
}

// 计算页面开始执行时间
list($usec, $sec) = explode(' ', microtime());
$start_time = ((float)$usec + (float)$sec);

// 页面当前执行的文件
$script_file = pathinfo($_SERVER['SCRIPT_FILENAME']);
$current_file = $script_file['basename'];
$script_file = substr($script_file['dirname'], strrpos($script_file['dirname'], '/')+1);

// 网站访问地址
if(!isset($base_url)) {
    $base_url  = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https://' : 'http://';
    $base_url .= preg_replace('/:80$/', '', $_SERVER['HTTP_HOST']) . str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
    if(substr($base_url, -1) == '/') {
        $base_url = substr($base_url, 0, -1);
    }
}
// 判断程序是否安装
if(!file_exists(GEN_ROOT . 'data/install.lock')) {
    die("<div>You haven't install this program, click \"<a href=".$base_url."/install/install.php>installation</a>\" into the installation interface</div>");
}

// 设置表前缀
if (!isset($prefix)) {
    $prefix = 'sg';
}

// 调用外部文件
require GEN_ROOT . 'includes/constant.inc.php';
@ini_set('session.cookie_lifetime', GEN_SESSION_GC_MAXLIFETIME);
require GEN_ROOT . 'includes/base.func.php';
require GEN_ROOT . 'includes/mysql.class.php';

// 初始化数据库类
$db = new mysql($db_host, $db_user, $db_pass, $db_name, $prefix);
$db_host = $db_user = $db_pass = $perfix = NULL;

require GEN_ROOT . 'includes/session.class.php';
require GEN_ROOT . 'includes/cache.class.php';
require GEN_ROOT . 'includes/common.func.php';
require GEN_ROOT . 'includes/error.class.php';
require GEN_ROOT . 'includes/image.class.php';
require GEN_ROOT . 'includes/libs/template/template.class.php';

// 初始化缓存类
$cache = new cache();

// 创建错误处理对象
$err = new gen_error('message.html');

// 载入系统参数
$_CONF = load_config();
$_CONF['memory_limit'] = '128M';

// 加载语言包
require GEN_ROOT . 'languages/' . $_CONF['lang'] . '/common.lang.php';

// 设置时区
setlocale(LC_CTYPE, 'C');
$timezone_identifiers = DateTimeZone::listIdentifiers();
if (!isset($_CONF['default_timezone']) || !in_array($_CONF['default_timezone'], $timezone_identifiers)) {  
    date_default_timezone_set('Asia/Chongqing');
} else {
    date_default_timezone_set($_CONF['default_timezone']);
}

// 获得客户端用户IP
$client_ip = (!empty($_SERVER['REMOTE_ADDR'])) ? $_SERVER['REMOTE_ADDR'] : ((!empty($_ENV['REMOTE_ADDR'])) ? $_ENV['REMOTE_ADDR'] : getenv('REMOTE_ADDR'));

// 转义所有用户提交的数据
if(!get_magic_quotes_gpc()) {
    if(is_array($_REQUEST)) {
        while(list($k, $v) = each($_REQUEST)) {
            if(is_array($_REQUEST[$k])) {
                while( list($k2, $v2) = each($_REQUEST[$k])) {
                    $_REQUEST[$k][$k2] = addslashes($v2);
                }
                @reset($_REQUEST[$k]);
            } else {
                $_REQUEST[$k] = addslashes($v);
            }
        }
        @reset($_REQUEST);
    }

    if(is_array($_GET)) {
        while(list($k, $v) = each($_GET)) {
            if(is_array($_GET[$k])) {
                while( list($k2, $v2) = each($_GET[$k])) {
                    $_GET[$k][$k2] = addslashes($v2);
                }
                @reset($_GET[$k]);
            } else {
                $_GET[$k] = addslashes($v);
            }
        }
        @reset($_GET);
    }

    if(is_array($_POST)) {
        while(list($k, $v) = each($_POST)) {
            if(is_array($_POST[$k])) {
                while(list($k2, $v2) = each($_POST[$k])) {
                    $_POST[$k][$k2] = addslashes($v2);
                }
                @reset($_POST[$k]);
            } else {
                $_POST[$k] = addslashes($v);
            }
        }
        @reset($_POST);
    }
    if(is_array($_COOKIE)) {
        while(list($k, $v) = each($_COOKIE)) {
            if(is_array($_COOKIE[$k])) {
                while(list($k2, $v2) = each($_COOKIE[$k])) {
                    $_COOKIE[$k][$k2] = addslashes($v2);
                }
                @reset($_COOKIE[$k]);
            } else {
                $_COOKIE[$k] = addslashes($v);
            }
        }
        @reset($_COOKIE);
    }
}

// 创建模板对象
$tpl = new template();

// 前台和后能使用不同的模板目录
if (!defined('IN_ADMIN')) {
    $tpl->cache_lifetime = $_CONF['cache_expect_time'];
    $tpl->template_dir   = GEN_ROOT . 'templates/' . $_CONF['tpl_name'];
    $tpl->cache_dir      = GEN_ROOT . 'data/tpl_caches';
    $tpl->compile_dir    = GEN_ROOT . 'data/tpl_compiles';
    $tpl->left_delimiter = '{{';
    $tpl->right_delimiter = '}}';
} else {
    $tpl->cache_lifetime = $_CONF['cache_expect_time'];
    $tpl->template_dir   = GEN_ROOT . 'admin/templates';
    $tpl->cache_dir      = GEN_ROOT . 'data/admin_tpl_caches';
    $tpl->compile_dir    = GEN_ROOT . 'data/admin_tpl_compiles';
    $tpl->left_delimiter = '{{';
    $tpl->right_delimiter = '}}';
}

if (isset($is_debug) && $is_debug == true) {
    $tpl->direct_output = false;
    $tpl->force_compile = false;
} else {
    $tpl->direct_output = true;
    $tpl->force_compile = true;
}

// 只有前台使用这些数据
if (!defined('IN_ADMIN')) {
    $tpl->assign('lang', $_LANG);
    $tpl->assign('gen_css_path', 'templates/' . $_CONF['tpl_name'] . '/style.css');
    $tpl->assign('gen_img_path', 'templates/' . $_CONF['tpl_name'] . '/images/');
    $tpl->assign('gen_version', GEN_VERSION);
    $tpl->assign('base_url', $base_url);
    assign_template();
    // 统计代码
    $tpl->assign('statistics_code', $_CONF['statistics_code']);
}

// 缩略图和高和宽
$theme_small['width']   = $_CONF['small_pic_width'];
$theme_small['height']  =  $_CONF['small_pic_height'];

// 中等大小的图片
$theme_middle['width']   = $_CONF['middle_pic_width'];
$theme_middle['height']  = $_CONF['middle_pic_height'];

// 初始化SESSION
session_name(GEN_SESSION_NAME);
$sess = new session($db);

// 判断是否支持 Gzip 模式
if (!defined('INIT_NO_SMARTY') && gzip_enabled()) {
    substr(PHP_VERSION, 0,3) < 5.3 ? ob_start('ob_gzhandler') : null;
}
else {
    ob_start();
}
?>
