--
-- 表的结构 `sg_admin`
--

CREATE TABLE IF NOT EXISTS `sg_admin` (
  `admin_id` smallint(3) unsigned NOT NULL auto_increment,
  `password` varchar(32) collate utf8_bin NOT NULL,
  `username` varchar(50) collate utf8_bin NOT NULL,
  `nickname` varchar(100) collate utf8_bin NOT NULL default 'Administrators',
  `register_ip` varchar(20) collate utf8_bin NOT NULL default '',
  `register_time` int(10) NOT NULL default '0',
  `last_login_ip` varchar(20) collate utf8_bin NOT NULL,
  `last_login_time` int(10) NOT NULL default '0',
  `last_edit_ip` varchar(50) collate utf8_bin NOT NULL default '0',
  `last_edit_time` int(10) NOT NULL default '0',
  PRIMARY KEY  (`admin_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- 表的结构 `sg_article`
--

CREATE TABLE IF NOT EXISTS `sg_article` (
  `article_id` int(10) unsigned NOT NULL auto_increment,
  `user_id` int(10) unsigned NOT NULL,
  `username` varchar(50) character set utf8 collate utf8_bin NOT NULL default '',
  `keywords` varchar(255) NOT NULL,
  `category_id` mediumint(8) unsigned default NULL,
  `category_name` varchar(100) character set utf8 collate utf8_bin default NULL,
  `tags_id` varchar(100) character set utf8 collate utf8_bin NOT NULL,
  `submit_time` int(11) NOT NULL default '0',
  `last_change_time` int(11) NOT NULL COMMENT '最后更新时间',
  `click_number` int(10) NOT NULL default '0',
  `subject` varchar(255) character set utf8 collate utf8_bin NOT NULL default '',
  `content` text character set utf8 collate utf8_bin NOT NULL,
  `repl_number` int(10) unsigned NOT NULL default '0',
  `is_original` tinyint(1) NOT NULL COMMENT '是否原创',
  `is_allow_comment` tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (`article_id`),
  KEY `user_id` (`user_id`),
  KEY `category_id` (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- 表的结构 `sg_category`
--

CREATE TABLE IF NOT EXISTS `sg_category` (
  `category_id` mediumint(8) unsigned NOT NULL auto_increment,
  `category_name` varchar(50) collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- 表的结构 `sg_comment_filter`
--

CREATE TABLE IF NOT EXISTS `sg_comment_filter` (
  `filter_id` int(10) NOT NULL auto_increment,
  `filter_name` varchar(50) character set utf8 default NULL,
  PRIMARY KEY  (`filter_id`),
  KEY `filter_id` (`filter_id`,`filter_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- 表的结构 `sg_conf`
--

CREATE TABLE IF NOT EXISTS `sg_conf` (
  `conf_name` varchar(155) collate utf8_bin NOT NULL,
  `conf_value` varchar(255) collate utf8_bin NOT NULL default '',
  `is_disable` tinyint(1) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 表的结构 `sg_image`
--

CREATE TABLE IF NOT EXISTS `sg_image` (
  `pic_id` int(10) unsigned NOT NULL auto_increment,
  `pic_name` varchar(50) NOT NULL,
  `small_pic` varchar(100) NOT NULL,
  `middle_pic` varchar(155) NOT NULL,
  `original_pic` varchar(55) NOT NULL,
  `pic_cate_id` int(10) NOT NULL,
  `pic_cate_name` varchar(50) NOT NULL,
  `upload_time` int(11) default NULL,
  PRIMARY KEY  (`pic_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


--
-- 表的结构 `sg_image_category`
--

CREATE TABLE IF NOT EXISTS `sg_image_category` (
  `cate_id` int(10) unsigned NOT NULL auto_increment,
  `admin_user_id` mediumint(8) default NULL,
  `admin_user_name` varchar(55) default NULL,
  `is_default_dir` tinyint(1) NOT NULL default '0',
  `cate_name` varchar(50) NOT NULL,
  `default_pic` varchar(150) default 'images/folderEmpty.png',
  `image_total` int(10) NOT NULL default '0',
  PRIMARY KEY  (`cate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- 表的结构 `sg_links`
--

CREATE TABLE IF NOT EXISTS `sg_links` (
  `link_id` mediumint(8) unsigned NOT NULL auto_increment,
  `link_name` varchar(150) collate utf8_bin NOT NULL default '0',
  `link_text` varchar(100) collate utf8_bin NOT NULL,
  `link_address` varchar(100) collate utf8_bin NOT NULL,
  `link_order` mediumint(8) NOT NULL default '0',
  `link_type` tinyint(1) NOT NULL default '1',
  `display_type` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`link_id`),
  KEY `link_order` (`link_address`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- 表的结构 `sg_navigation`
--

CREATE TABLE IF NOT EXISTS `sg_navigation` (
  `nav_id` mediumint(8) unsigned NOT NULL auto_increment,
  `nav_name` varchar(100) NOT NULL,
  `nav_url` varchar(100) NOT NULL,
  `display_order` mediumint(8) unsigned NOT NULL,
  `is_unlock` tinyint(1) unsigned NOT NULL,
  `target_type` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY  (`nav_id`),
  KEY `display_order` (`display_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- 表的结构 `sg_reply`
--

CREATE TABLE IF NOT EXISTS `sg_reply` (
  `reply_id` int(10) unsigned NOT NULL auto_increment,
  `article_id` int(10) unsigned NOT NULL,
  `author_name` varchar(50) collate utf8_bin NOT NULL default '',
  `email` varchar(50) collate utf8_bin NOT NULL default '',
  `website` varchar(100) character set utf8 NOT NULL,
  `author_ip` varchar(30) collate utf8_bin NOT NULL default '',
  `submit_time` int(10) NOT NULL default '0',
  `format_time` varchar(20) collate utf8_bin NOT NULL,
  `content` text collate utf8_bin NOT NULL,
  `user_pic` varchar(180) collate utf8_bin NOT NULL,
  `admin_user_id` mediumint(8) unsigned default NULL,
  `admin_user_name` varchar(25) collate utf8_bin default NULL,
  `admin_reply_content` varchar(255) collate utf8_bin default NULL,
  `admin_last_change_time` int(11) default NULL,
  `is_auth` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`reply_id`),
  KEY `admin_user_id` (`admin_user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `sg_sessions`
--

CREATE TABLE IF NOT EXISTS `sg_sessions` (
  `session_id` int(10) unsigned NOT NULL auto_increment,
  `session` varchar(255) collate utf8_bin NOT NULL,
  `session_expires` int(10) unsigned NOT NULL default '0',
  `session_data` mediumtext collate utf8_bin,
  PRIMARY KEY  (`session_id`),
  KEY `session` (`session`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


-- --------------------------------------------------------

--
-- 表的结构 `sg_statistics`
--

CREATE TABLE IF NOT EXISTS `sg_statistics` (
  `sta_id` int(10) unsigned NOT NULL auto_increment,
  `visit_count` int(10) unsigned NOT NULL default '0',
  `subscribe_count` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`sta_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- 表的结构 `sg_tags`
--

CREATE TABLE IF NOT EXISTS `sg_tags` (
  `tag_id` mediumint(8) unsigned NOT NULL auto_increment,
  `tag_name` varchar(50) collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`tag_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;