<?php
/**
 * Copyright (C) 2009  Honghao Geng (genghonghao@gmail.com)
 * $Id: function.inc.php 496 2009-12-30 16:19:04Z genghonghao $
 */

// 测试安装环境是否合法
function CheckSurr() {
    global $root_directory, $txt;
    $error = 0;
    // 检察DATA目录是否可写
    $dirs = read_dir($root_directory . 'data');
    foreach($dirs AS $key=>$val) {
        if (file_perms($val) == 777) {
            $dirs[$key] = $val.'&nbsp;&nbsp;'.$txt['can_write'];
        } else {
            
            if ('win' == strtolower(substr(PHP_OS, 0, 3))) {
                $dirs[$key] = $val.'&nbsp;&nbsp;'.$txt['can_write'];
            } else {
                $dirs[$key] = $val.'&nbsp;&nbsp;'.$txt['not_write'];
                $error++;
            }
        }
    }
    $dir_code = implode('</li><li>', $dirs);
    $dir_code = '<ul><li>' . $dir_code . '</li></ul>';
    return array($dir_code, $error);
}

// 获得文件的权限
function file_perms($file, $octal = 2) {
    if(!file_exists($file)) return false;

    $perms = fileperms($file);

    $cut = $octal;

    return trim(substr(decoct($perms), $cut), '0');
}

// 读取当前目录下的所有目录和文件
function read_dir($dir) {
    if (is_dir($dir)) {
        $dirs[] = $dir;
        if ($dh = @opendir($dir)) {
            while (($file = readdir($dh)) !== false) {
                if ('.' != $file && '..' != $file && 'index.html' != $file && '.svn' != $file && 'install.lock' != $file) {
                    $new_file = ($dir . '/' . $file);
                    $dirs[] = $new_file;
                    if (is_dir($new_file)) {
                        read_dir($new_file);
                    }
                }

            }
            closedir($dh);
        }
    }
    return isset($dirs) ? $dirs : array();
}

// 后退
function go_back($content) {
    header('Content-Type: text/html; charset=utf-8');
    echo "<script type='text/javascript'>alert('$content');history.go(-1);</script>";
    exit();
}

// 写config文件
function gen_config($db_host, $db_user, $db_pass, $db_name) {
    global $root_directory ;
    $newline = (strtolower(PHP_OS) == 'linux') ? "\n" : "\r\n";
    $content = "<?php$newline";
    $content .= "\$db_host = '$db_host';$newline";
    $content .= "\$db_user = '$db_user';$newline";
    $content .= "\$db_pass = '$db_pass';$newline";
    $content .= "\$db_name = '$db_name';$newline";
    $content .= "\$prefix = 'sg_';$newline";
    $content .= "\$is_debug = true;$newline";
    $content .= "?>";
    $config_file = $root_directory . '/data/config.inc.php';
    $fp = fopen($config_file, 'wb');
    fwrite($fp, $content);
    fclose($fp);
}

// 读取文件中的内容
function get_sql($file_name) {
    return file_get_contents($file_name);
}
?>
