<?php
/**
 * Copyright (C) 2009  Honghao Geng (genghonghao@gmail.com)
 * $Id: list.php 576 2010-07-30 19:17:03Z genghonghao $
 */

define('IN_GEN', true);
include './includes/common.inc.php';
require GEN_ROOT . 'includes/page.class.php';

// 判断网站是否关闭
close_blog();

// 右侧导航数据
assign_right_list();

// 页面执行时间
list($usec, $sec) = explode(' ', microtime());
$time_diff = number_format(((float)$usec + (float)$sec) - $start_time, 6);
$tpl->assign('time_diff', $time_diff);

// 取出头部导航数据
$nav_list = $db->result("SELECT * FROM " . $db->get_table(TB_NAVIGATION) . " WHERE is_unlock='1' ORDER BY display_order ASC");
$tpl->assign('nav_list', $nav_list);

// SQL执行次数
$tpl->assign('queries', $db->get_num_queries());

// 当前时间
$tpl->assign('current_time', 'GMT' . date("O, Y-m-d H:i:s"));

$arr_replace = array('search', 'tag', 'category', 'filing');

$action = isset($_REQUEST['act']) ? urldecode(trim($_REQUEST['act'])) : NULL;
$step   = isset($_REQUEST['step']) ? trim($_REQUEST['step']) : NULL;
if ($action === NULL || $step === NULL || !in_array($step, $arr_replace))
{
	redirect_page('Failure', $_LANG['notice_param_not'], $base_url.'/index.php');
}

$where = '';
switch ($step)
{
	case 'search':
        $action = $action == $_LANG['please_input_keyword'] ? '' : $action;
		$where = " subject LIKE '%{$action}%'";
		$nav = $_LANG['list_blog_search'] . $action;
	break;
	case 'tag' :
		$where = " tags_id LIKE '{$action}%' OR tags_id LIKE '%,{$action}%'";
		$nav = $_LANG['list_tag_list'] .  get_name('tags', $action);
	break;
	case 'category' :
		$where = " category_id='{$action}'";
		$nav = $_LANG['list_cat_list'] . get_name('category', $action);;
	break;
	case 'filing' :
        if (strpos($action, '-') == false) {
            header("Location: index.php");
            exit();
        }
		$arr = explode('-', $action);
        if (count($arr) != 2) {
            header("Location: index.php");
            exit();
        }
        preg_match("/^(\d{1,2})(.+)/i", $arr[1], $month);
		$start = mktime(0, 0, 0, $month[1], 1, $arr[0]);
		$last_day = date('t', $start);
		$end = mktime(12, 59, 59, $month[1], $last_day, $arr[0]);
		$where = " submit_time>'{$start}' AND submit_time<'{$end}'";
		$nav = $_LANG['list_file_list'] . $action;
	break;
}
$tpl->assign('nav', $nav);

$temp = $db->result("SELECT COUNT(*) AS num FROM " . $db->get_table(TB_ARTICLE) . " WHERE " . $where);
$total = $temp[0]['num'];
$perpage = isset($_CONF['search_view_number']) ? intval($_CONF['search_view_number']) : 100;
if (!isset($_REQUEST['page']) || is_int($_REQUEST['page']))
{
	$p = 0;
}
else
{
	$p = ((int)$_REQUEST['page'] - 1) * $perpage;
	if ($p >= $total)
	{
		$p = 0;
	}
}

$result = $db->result("SELECT * FROM " . $db->get_table(TB_ARTICLE) . ' WHERE ' . $where . " ORDER BY article_id DESC LIMIT {$p}, {$perpage}");
foreach($result AS $key=>$val) {
    $result[$key]['view_subject'] = sub_str(strip_tags($val['subject']),  30);
    $result[$key]['subject'] = htmlspecialchars($val['subject']);
}
$tpl->assign('list', $result);

$page=new page(array('total'=>$total,'perpage'=>$perpage));
$tpl->assign('page', $page->show(4));
$tpl->display('list.html');

?>
