<?php
/**
 * Copyright (C) 2009  Honghao Geng (genghonghao@gmail.com)
 * $Id: rss.php 574 2010-07-10 16:30:13Z genghonghao $
 */

//
error_reporting(0);
define('IN_GEN', true);
$timestamp = time();
$dataarray = array();

require_once './includes/common.inc.php';

$num = 20;
$ttl = 15;

if (isset($_REQUEST['rsstype']) && !empty($_REQUEST['rsstype'])) {
    $rsstype = trim($_REQUEST['rsstype']);
    if ($rsstype == 'comments') {
        $rss_title = $_LANG['rss_comment_list'];
        $sql = "SELECT r.*, a.subject, a.username, c.category_name ";
        $sql .= "FROM ". $db->get_table(TB_ARTICLE) . " AS a, " . $db->get_table(TB_CATEGORY) . " AS c, " . $db->get_table(TB_REPLY) . " AS r ";
        $sql .= "WHERE r.article_id=a.article_id AND a.category_id=c.category_id  ORDER BY r.reply_id DESC LIMIT $num";
        $dataarray = $db->result($sql);
    } else {
        $rsstype = 'article';
        $rss_title = $_LANG['rss_article_list'];
        $dataarray = $db->result("SELECT a.*, c.category_name FROM " . $db->get_table(TB_ARTICLE) . " AS a, " . $db->get_table(TB_CATEGORY) . " AS c WHERE a.category_id=c.category_id ORDER BY a.article_id DESC LIMIT $num");
    }
} else {
    $rsstype = 'article';
    $rss_title = $_LANG['rss_article_list'];
    $dataarray = $db->result("SELECT a.*, c.category_name FROM " . $db->get_table(TB_ARTICLE) . " AS a, " . $db->get_table(TB_CATEGORY) . " AS c WHERE a.category_id=c.category_id ORDER BY a.article_id DESC LIMIT $num");
}

$PHP_SELF = $_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME'];
$boardurl = 'http://'.$_SERVER['HTTP_HOST'].substr($PHP_SELF, 0, strrpos($PHP_SELF, '/') + 1);

header("Content-type: application/xml");
echo 	"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".
    "<rss version=\"2.0\">\n".
    "  <channel>\n".
    (count($dataarray) > 1 ?
    "    <title>{$_CONF['site_name']}-$rss_title</title>\n".
    "    <link>{$boardurl}?rsstype=$rsstype</link>\n".
    "    <description>Latest $num content of all category</description>\n"
    :
    "    <title>{$_CONF['site_name']}-$rss_title</title>\n".
    "    <link>{$boardurl}?rsstype=$rsstype</link>\n".
    "    <description>Latest $num threads of $rss_title</description>\n"
    ).
    "    <copyright>Copyright(C) SMARTGOON!</copyright>\n".
    "    <generator>SMARTGOON CMS by Xuewu.</generator>\n".
    "    <lastBuildDate>".gmdate('r', $timestamp)."</lastBuildDate>\n".
    "    <ttl>$ttl</ttl>\n".
    "    <image>\n".
    "      <url>{$boardurl}images/logo.gif</url>\n".
    "      <title>{$_CONF['site_name']}</title>\n".
    "      <link>{$boardurl}</link>\n".
    "    </image>\n";

if($dataarray) {
    foreach($dataarray AS $item) {
        echo 	"    <item>\n".
            "      <title>".htmlspecialchars($item['subject'])."</title>\n".
            "      <link>{$boardurl}view_content.php?aid={$item['article_id']}</link>\n".
            "      <description><![CDATA[" . $item['content'] ."]]></description>\n".
            "      <category>".htmlspecialchars($item['category_name'])."</category>\n".
            "      <author>".htmlspecialchars($item['username'])."</author>\n".
            "      <pubDate>".gmdate('r', $item['submit_time'])."</pubDate>\n".
            "    </item>\n";
    }
}
echo 	"  </channel>\n".
    "</rss>";
?>
