<?php
/**
 * Copyright (C) 2009  Honghao Geng (genghonghao@gmail.com)
 * $Id: view_content.php 567 2010-04-15 15:39:07Z genghonghao $
 */

define('IN_GEN', true);
include './includes/common.inc.php';
require GEN_ROOT . 'includes/page.class.php';

// 判断网站是否关闭
close_blog();

// 取出广告数据
@include GEN_ROOT . '/data/ad_conf.php';
if (isset($ad_array)) {
    $tpl->assign('ad', $ad_array);
}

// 获取当前文章的ID
$aid = isset($_REQUEST['aid']) ? intval($_REQUEST['aid']) : false;
if (false === $aid) {
    header('Location: index.php');
}
$current_page_url = $_SERVER['PHP_SELF'] . '?' . get_uri_param_string();
$tpl->assign('current_page_url', $current_page_url);

// 提交评论
if (isset($_REQUEST['text_article_id'])) {
    $is_auth = isset($_CONF['enable_verify_comment']) ? (1 == intval($_CONF['enable_verify_comment']) ? 0 : 1) : 0;
    $article_id = trim($_REQUEST['text_article_id']);
    $name = trim($_REQUEST['text_name']);
    $email = trim($_REQUEST['text_email']);
    $website = trim($_REQUEST['text_website']) == 'Website' ? '' : trim($_REQUEST['text_website']);
    $cur_time = time();
    $format_time = date("Y-m-d H:i:s");
    $comment = trim($_REQUEST['text_comment']);
    $user_pic = NULL;

    // 记录用户留言身份
    $_SESSION['guest']['name'] = $name;
    $_SESSION['guest']['email'] = $email;
    $_SESSION['guest']['website'] = $website;

    // 获取评论过滤数据
    $filters = $db->result("SELECT filter_name FROM " . $db->get_table(TB_COMMENT_FILTER));
    $filter = array();
    foreach($filters AS $val) {
        $filter[] = $val['filter_name'];
    }
    // 过滤评论数据
    $comment = str_replace($filter, $_LANG['filter_text'], $comment);
    $sql = "INSERT INTO " . $db->get_table(TB_REPLY) . " VALUES(NULL, '$article_id','$name', '$email', '$website','$client_ip', '$cur_time', '$format_time', '$comment', '$user_pic', NULL, '', '', NULL, '$is_auth')";

    if ($db->query($sql, '', 1)) {
        // 修改评论数
        $db->query("UPDATE " . $db->get_table(TB_ARTICLE) . " SET repl_number=repl_number+1 WHERE article_id='$article_id'");
        page_redirect('Success', $_LANG['notice_sub_comment_success'], $current_page_url."#comment_header");
    } else {
        page_redirect('Failure', $_LANG['notice_sub_comment_failure'], $current_page_url."#text_comment");
    }
}

// 用户的游客身份
if (isset($_SESSION['guest']) && is_array($_SESSION['guest']) && count($_SESSION['guest']) == 3) {
    $tpl->assign('guest', $_SESSION['guest']);
}

$temp = $db->result("SELECT COUNT(*) AS num FROM " . $db->get_table(TB_REPLY) . " WHERE article_id='$aid' AND is_auth='1'");
$total = $temp[0]['num'];

$perpage = (isset($_CONF['comment_view_number']) && !empty($_CONF['comment_view_number'])) ? intval($_CONF['comment_view_number']) : 50;
if (!isset($_REQUEST['page']) || is_int($_REQUEST['page'])) {
    $p = 0;
}
else {
    $p = ((int)$_REQUEST['page'] - 1) * $perpage;
    if ($p >= $total) {
        $p = 0;
    }
}

$tpl->assign('base_url', $base_url);

// 博客内容
$article = $db->result("SELECT c.category_name, a.*, u.nickname 
                            FROM " . $db->get_table(TB_ARTICLE) . " AS a " . 
        "LEFT JOIN " . $db->get_table(TB_CATEGORY) . " AS c ON (a.category_id=c.category_id) " .
        "LEFT JOIN " . $db->get_table(TB_ADMIN) . " AS u ON (a.user_id=u.admin_id) " . "WHERE a.article_id='$aid'
        ");
if (!is_array($article) || 1 > count($article)) {
        header("Location: index.php");
}
// 取得标签
$cur_tags = array();
if (isset($article) && is_array($article)) {
    $tags_id = trim($article[0]['tags_id'], ',');
    if ($tags_id != '') {
        $cur_tags = $db->result("SELECT tag_id, tag_name FROM " . $db->get_table(TB_TAGS) . " WHERE tag_id IN ($tags_id)");
    }
}
$article[0]['tags_id'] = $cur_tags;

$article[0]['content'] = str_replace('[code]', "<pre class='prettyprint  lang-php'>", str_replace('[/code]', '</pre>', $article[0]['content']));
$tpl->assign('article', $article);
$tpl->assign('comment_count', sprintf($_LANG['comment_count'], $article[0]['repl_number']));

// 查询留言数据
$reply_result = $db->result("SELECT * FROM " . $db->get_table(TB_REPLY) . " WHERE article_id='$aid' AND is_auth='1' ORDER BY reply_id ASC LIMIT {$p}, {$perpage}");

// 整理数据
$j = 1;
foreach ($reply_result AS $key=>$val) {
    $reply_result[$key]['entites_content'] = htmlspecialchars(str_replace("'", '&apos;', $reply_result[$key]['content']));
    $reply_result[$key]['content'] = htmlspecialchars_decode(str_replace("&apos;", "'", $reply_result[$key]['content']));

    $patterns[0] = "/(\[img src=)/";
    $patterns[1] = "/(\d{8,})/";
    $patterns[2] = "/(\])/";

    $replacements[0] = "";
    $replacements[1] = "<img src='images/smilies/\\1.gif'/>";
    $replacements[2] = "";
    $reply_result[$key]['content'] = preg_replace($patterns, $replacements, $reply_result[$key]['content']);
    $reply_result[$key]['content'] = str_replace($base_url.'/images/smilies/', 'images/smilies/', $reply_result[$key]['content']);
    $reply_result[$key]['lou'] = $j;
    $j++;
}
// 把评论数据传递到模板
$tpl->assign('reply_list1', $reply_result);

if (!isset($_SESSION['user']['click_number'.$aid])) {
    $db->query("UPDATE ". $db->get_table(TB_ARTICLE) . " SET click_number=click_number+1 WHERE article_id='$aid'");
    $_SESSION['user']['click_number'.$aid] = TRUE;
}

// 分页
$page = new page(array('total'=>$total,'perpage'=>$perpage));
$tpl->assign('page', $page->show(4));

// 右侧导航数据
assign_right_list();

// 页面执行时间
list($usec, $sec) = explode(' ', microtime());
$time_diff = number_format(((float)$usec + (float)$sec) - $start_time, 6);
$tpl->assign('time_diff', $time_diff);

// 取出头部导航数据
$nav_list = $db->result("SELECT * FROM " . $db->get_table(TB_NAVIGATION) . " WHERE is_unlock='1' ORDER BY display_order ASC");
$tpl->assign('nav_list', $nav_list);

// SQL执行次数
$tpl->assign('queries', $db->get_num_queries());

// 当前时间
$tpl->assign('current_time', 'GMT' . date("O, Y-m-d H:i:s"));

// 小图标
$tpl->assign('smilies', get_smilies());

// 判断当前文章是否可以评论
if ($article[0]['is_allow_comment'] == 0 || $_CONF['enable_comment'] == 0) {
    $tpl->assign('is_allow_comment', 0);
} else {
    $tpl->assign('is_allow_comment', 1);
}

$tpl->display('view_content.html');

function get_smilies() {
    global $root_url, $base_url;
    $dir = 'images/smilies';
    $arr = array();
    $arr1 = array();
    if (is_dir($dir)) {
        if ($dh = @opendir($dir)) {
            while (($file = readdir($dh)) !== false) {
                if($file != '.' && $file != '..' && strpos($file, '.gif') !== false) {
                    $temp = "[img src=" . substr($file, 0, strpos($file,'.'))."]";
                    $arr[] = '<img src=' . $base_url . '/images/smilies/' . $file . ' border=0 height=25 width=25 onclick="fnInsertEditor(\''.$temp.'\');"/>';
                }
            }
            closedir($dh);
        }
    }
    return $arr;
}
?>
