<?php 

//过滤脚本代码
function cleanJs($text) 
{
$text = trim ( $text );
$text = stripslashes ( $text );
//完全过滤注释
$text = preg_replace ( '/<!--?.*-->/', '', $text );
//完全过滤动态代码
$text = preg_replace ( '/<\?|\?>/', '', $text );
//完全过滤js
$text = preg_replace ( '/<script?.*\/script>/', '', $text );
//过滤多余html
$text = preg_replace ( '/<\/?(html|head|meta|link|base|body|title|style|script|form|iframe|frame|frameset)[^><]*>/i', '', $text );
//过滤on事件lang js
while ( preg_match ( '/(<[^><]+)(lang|onfinish|onmouse|onexit|onerror|onclick|onkey|onload|onchange|onfocus|onblur)[^><]+/i', $text, $mat ) ) {
$text = str_replace ( $mat [0], $mat [1], $text );
}
while ( preg_match ( '/(<[^><]+)(window\.|javascript:|js:|about:|file:|document\.|vbs:|cookie)([^><]*)/i', $text, $mat ) ) {
$text = str_replace ( $mat [0], $mat [1] . $mat [3], $text );
}
//过滤多余空格
$text = str_replace ( '  ', ' ', $text );
return $text;
}
//纯文本输出
function t($text) 
{
$text = cleanJs ( $text );
$text = strip_tags ( $text );
$text = htmlspecialchars ( $text );
return $text;
}
//输出安全的html
function h($text) 
{
$text = cleanJs ( $text );
return $text;
}


/**
* # 页面跳转至($url, $time, $msg)
* # 'template/redirect.html' 为跳转页模板
*/
function redirect($url,$l2=0,$msg='')
{
// URL, 停留时间, 显示消息
//多行URL地址支持
$url = str_replace(array("\n", "\r"), '', $url);
$msg = $msg ? $msg : '页面跳转中....';   //定义变量$msg为空和不为空情况下的跳转说明
$js  = "<script language='javascript' type='text/javascript'>window.setTimeout(function () { document.location.href='$url';}, '".($l2*1000)."');</script>";
if (!headers_sent()) {
// redirect
header('Content-Type:text/html; charset=utf-8');
if ($l2 === 0) {
header("Location:$url");
} else {
header("refresh:$l2;url=$url");
include('./template/redirect.html');
exit();
}
exit();
} else {
$l4 = "<meta http-equiv='refresh' content='$l2'; url='$url' />";
if ($l2!=0) {
include('./template/redirect.html');
exit();
}
exit();
}
}



/**
* 加载模板文件
*
* @param string $template 模板名
* @param string $ext 模板后缀名
* @return string 模板路径
*/
function getViews($template, $ext = '.php')
{
if (!is_dir(TEMPLATE_PATH)){
exit('The Template Path Error');
}
$path = TEMPLATE_PATH.$template.$ext;
return $path;
}

/**
* 去除多余的转义字符
*
*/
function doStripslashes()
{
if (get_magic_quotes_gpc())
{
$_GET = stripslashesDeep($_GET);
$_POST = stripslashesDeep($_POST);
$_COOKIE = stripslashesDeep($_COOKIE);
$_REQUEST = stripslashesDeep($_REQUEST);
}
}


/**
* 获取网站地址(仅限根目录脚本使用,目前仅用于首页ajax请求)
*/
function getSiteUrl()
{
$phpself = isset($_SERVER['SCRIPT_NAME']) ? $_SERVER['SCRIPT_NAME'] : '';
if(preg_match("/^.*\//", $phpself, $matches))
{
return 'http://'.$_SERVER['HTTP_HOST'].$matches[0];
}
else
{
return SITE_URL;
}
}


/**
* 该函数在插件中调用,挂载插件函数到预留的钩子上
* 
* @param string $hook 
* @param string $actionFunc
* @return boolearn
*/
function addAction($hook, $actionFunc)
{
global $emHooks;
if (!@in_array($actionFunc, $emHooks[$hook]))
{
$emHooks[$hook][] = $actionFunc;
}
return true;
}

/**
* 执行挂在钩子上的函数,支持多参数 eg:doAction('post_comment', $author, $email, $url, $comment);
*
* @param string $hook
*/
function doAction($hook)
{
global $emHooks;
$args = array_slice(func_get_args(), 1);
if (isset($emHooks[$hook]))
{
foreach ($emHooks[$hook] as $function)
{
$string = call_user_func_array($function, $args);
}
}
}

/**
* 分页函数
*
* @param int $count 条目总数
* @param int $perlogs 每页显示条数目
* @param int $page 当前页码
* @param string $url 页码的地址
* @return unknown
*/
function pagination($count,$perlogs,$page,$url)
{
$pnums = @ceil($count / $perlogs);
$re = '';
for ($i = $page-5;$i <= $page+5 && $i <= $pnums; $i++)
{
if ($i > 0)
{
if ($i == $page)
{
$re .= " <span class='current'>$i</span> ";
} else 
{
$re .= " <a href=\"$url=$i\">$i</a> ";
}
}
}
if ($page > 6) $re = "<a href=\"$url=1\" title=\"首页\">&laquo;</a> ...$re";
if ($page + 5 < $pnums) $re .= "... <a href=\"$url=$pnums\" title=\"尾页\">&raquo;</a>";
if ($pnums <= 1) $re = '';
return $re;
}

//系统消息
function qiMsg($msg,$url='javascript:history.back(-1);', $isAutoGo=false)
{
echo <<<EOT
<html>
<head>
EOT;
if($isAutoGo)
{
echo "<meta http-equiv=\"refresh\" content=\"2;url=$url\" />";
}
echo <<<EOT
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>时尚起义系统消息</title>
<style type="text/css">
<!--
body {
background-color:#F7F7F7;
font-family: Arial;
font-size: 12px;
line-height:150%;
}
.main {
background-color:#FFFFFF;
margin-top:20px;
font-size: 12px;
color: #666666;
width:580px;
margin:10px 200px;
padding:10px;
list-style:none;
border:#DFDFDF 1px solid;
}
.main p {
line-height: 18px;
margin: 5px 20px;
}
-->
</style>
</head>
<body>
<div class="main">
<p>$msg</p>
<p><a href="$url">&laquo;点击返回</a></p>
</div>
</body>
</html>
EOT;
exit;
}

//网站信息
function siteMsg($msg)
{
echo <<<EOT
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>时尚起义 - www.77661.cn</title>
<style type="text/css">
<!--
body {
background-color:#F7F7F7;
font-family: Arial;
font-size: 12px;
line-height:150%;
}
.main {
background-color:#FFFFFF;
margin-top:20px;
font-size: 12px;
color: #666666;
width:580px;
margin:10px 200px;
padding:10px;
list-style:none;
border:#DFDFDF 1px solid;
}
.main p {
line-height: 18px;
margin: 5px 20px;
}
-->
</style>
</head>
<body>
<div class="main">
<p>$msg</p>
</div>
</body>
</html>
EOT;
exit;
}



?>