<?php
/**
 * RSS输出
 * rss.php
 *By QINIAO
 */

require_once('init.php');

//获取url地址

function GetURL()
{
	$path = $_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF'];
	$path = str_replace("/rss.php","",$path);
	Return $path;
}

$cate = isset($_GET['cate']) ? intval($_GET['cate']) : '';

require_once('model/class.mlog.php');
require_once('model/class.user.php');
require_once('model/class.cates.php');

$qiMlog = new qiMlog($DB);
$qiUser = new qiUser($DB);
$qiCate = new qiCate($DB);

$URL = GetURL();

$mlogs = $qiMlog->getMlogForRss();
foreach($mlogs as $key=>$val)
{
$val['cname'] = $qiCate->getCateName($val['cid']);
$val['truename'] = $qiUser->getUserName($val['uid']);
$val['cTime'] = date('Y-m-d H:i:s',$val['cTime']);
$mlogs[$key] = $val;
}

echo <<< END
<?xml version="1.0" encoding="utf-8"?>
<rss version="2.0">
<channel>
<title><![CDATA[{$sitename}]]></title> 
<description><![CDATA[{$sitedesc}]]></description>
<link>http://{$URL}</link>
<language>zh-cn</language>
<generator>www.77661.cn</generator>
<image>
<title>{$sitename}</title>
<url>http://{$URL}/images/logo.gif</url>
<link>http://{$URL}/</link>
<description>时尚起义</description>
</image>


END;
foreach($mlogs as $key=>$mlog)
{

echo <<< END
<item>
	<title>{$mlog['cname']}</title>
	<link>http://{$URL}/topic.php?id={$mlog['cid']}</link>
	<description><![CDATA[{$mlog['content']}]]></description>
	<pubDate>{$mlog['cTime']}</pubDate>
	<author>{$qiUser->getUserName($mlog['uid'])}</author>
	<guid>http://{$URL}/reply.php?id={$mlog['id']}</guid>

</item>
END;
}
echo <<< END
</channel>
</rss>
END;


?>
