<?php

// include files
require_once(WEB_ROOT . '/utilities/common.php');
require_once(WEB_ROOT . '/utilities/plugin.php');
require_once(WEB_ROOT . '/utilities/weblate.php');
require_once(WEB_ROOT . '/utilities/constant.php');

require_once(WEB_ROOT . '/business_logic/user_logic.php');
require_once(WEB_ROOT . '/business_logic/category_logic.php');

// declare class
abstract class action
{
    protected $theme_file;
    protected $weblate;

    // constructor
    // $theme_path: theme path
    // $theme_file: theme file name, relative to theme root
    public function __construct($theme_path, $theme_file)
    {
        // initialize data members
        $this->theme_file = $theme_file;
        $this->weblate = new weblate(WEB_ROOT, $theme_path);

        // automatic login
        $this->auto_login();
        
        // initialize referer url
        $this->init_referer_url();
        
        // load all active plugins
        plugin::load_active_plugins();
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->theme_file);
        unset($this->weblate);
    }

    // automatic login
    private function auto_login()
    {
        $username = $_COOKIE[USERNAME];
        $password = $_COOKIE[PASSWORD];
        if ($username != null && $password != null)
        {
            $user = user_logic::user_login(base64_decode($username), base64_decode($password));
            if ($user != null)
                $this->set_login_user($user);
        }
    }
    
    // initialize referer url
    private function init_referer_url()
    {
        session_start();
        $referer_url = $_SERVER['HTTP_REFERER'];
        if ($referer_url != null && $referer_url != $_SESSION[REFERER_URL])
            $_SESSION[REFERER_URL] = $referer_url;
    }

    // get login user
    // returns: login user
    protected function get_login_user()
    {
        session_start();
        return $_SESSION[LOGIN_USER];
    }

    // set login user
    // $user: user account
    protected function set_login_user($user)
    {
        session_start();
        $_SESSION[LOGIN_USER] = $user;
    }

    // prepare action
    // returns: true if prepare resource successfully, otherwise false
    public function prepare()
    {
        // make sure that the sub-actions can execute itself always 
        // while it dosn't overwrite this method
        return true;
    }

    // execute action
    // returns: weblate instance if successful, otherwise null
    public function execute()
    {
        if ($this->weblate->load($this->theme_file))
        {
            // global variables
            $this->weblate->assign("url", $_GET);
            $this->weblate->assign("referer_url", $_SESSION[REFERER_URL]);
            $this->weblate->assign("login_user", $this->get_login_user());
            $this->weblate->assign("all_categories", category_logic::get_all_categories());

            // hook global plugins
            plugin::trigger('all', $this->weblate);
            return $this->weblate;
        }
        return null;
    }
}

?>