<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/utilities/pagination.php');

require_once(WEB_ROOT . '/business_logic/post_logic.php');
require_once(WEB_ROOT . '/business_logic/options_logic.php');
require_once(WEB_ROOT . '/business_logic/comment_logic.php');
require_once(WEB_ROOT . '/business_logic/category_logic.php');
require_once(WEB_ROOT . '/business_logic/post_category_relationship_logic.php');

// declare class
class category_action extends action
{
    private $id;
    private $category;
    private $pagination;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(THEME_PATH, $theme_file);

        // initialize data members
        $this->id = @intval($_GET['id']);
        $this->pagination = new pagination();
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->id);
        unset($this->category);
        unset($this->pagination);
    }

    // prepare action
    // returns: true if prepare successful, otherwise false
    public function prepare()
    {
        // get category by id
        $this->category = category_logic::get_category($this->id);
        if ($this->category != null)
        {
            // apply custom theme file
            if ($this->category['theme_file'] != null)
                $this->theme_file = $this->category['theme_file'];

            // prepare pagination data
            $count = post_category_relationship_logic::get_post_count($this->id);
            return $this->pagination->prepare($count, POST_COUNT_PER_PAGE);
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign pagination vars
            $this->pagination->assign($weblate);

            // assign variables
            $weblate->assign("category", $this->category);
            $weblate->assign("parent_category", category_logic::get_category($this->category['parent_id']));
            $weblate->assign("sub_categories", category_logic::get_sub_categories($this->id));

            $weblate->assign("posts", post_logic::get_posts($this->id, $this->pagination->current_page - 1));
            $weblate->assign("hot_posts", post_logic::get_hot_posts($this->id));

            $weblate->assign("recent_comments", comment_logic::get_recent_comments());
            $weblate->assign("options", options_logic::get_options(null));

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>