<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');

require_once(WEB_ROOT . '/business_logic/user_logic.php');
require_once(WEB_ROOT . '/business_logic/category_logic.php');

// declare class
class login_action extends action
{
    private $username;
    private $password;
    private $login_failed;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(THEME_PATH, $theme_file);

        // initialize data members
        $this->username = $_POST['username'];
        $this->password = $_POST['password'];
        $this->login_failed = false;
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->username);
        unset($this->password);
        unset($this->login_failed);
    }

    // save login account
    private function save_account()
    {
        setcookie(USERNAME, base64_encode($this->username), COOKIE_EXPIRE);
        setcookie(PASSWORD, base64_encode(md5($this->password)), COOKIE_EXPIRE);
    }
    
    // remove account's password
    private function remove_account()
    {
        $expire = time() - 3600 * 24 * 30;
        setcookie(PASSWORD, "", $expire);
    }

    // prepare action
    public function prepare()
    {
        // login with user name and password
        if ($_SERVER['REQUEST_METHOD'] == HTTP_POST)
        {
            $user = user_logic::user_login($this->username, md5($this->password));
            if ($user != null)
            {
                // save user to session
                $this->set_login_user($user);

                // save/remove login account
                if ($_POST['save_account'] == 'on')
                    $this->save_account();
                else
                    $this->remove_account();

                // redirect page
                common::redirect_page("dispatch.php?action=admin_posts");
            }
            else
            {
                // set login status, the login page can show an error message with this
                $this->login_failed = true;
            }
        }
        return true;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign variables
            $weblate->assign("username", $this->username);
            $weblate->assign("password", $this->password);
            $weblate->assign("login_failed", $this->login_failed);

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>