<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/utilities/pagination.php');

require_once(WEB_ROOT . '/business_logic/page_logic.php');
require_once(WEB_ROOT . '/business_logic/comment_logic.php');

// declare class
class page_action extends action
{
    private $id;
    private $page;
    private $pagination;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(THEME_PATH, $theme_file);

        // initialize data members
        $this->id = @intval($_GET['id']);
        $this->pagination = new pagination();
    }

    // destructor
    public function __destruct()
    {
        unset($this->id);
        unset($this->page);
        unset($this->pagination);
    }

    // for get request
    // returns: true if successful, otherwise false
    private function do_get()
    {
        if (page_logic::update_read_count($this->id) > 0)
        {
            return $this->pagination->prepare($this->page['comment_count'], COMMENT_COUNT_PER_PAGE);
        }
        return false;
    }
    
    // for page request
    // returns: redirect page if successful, otherwise false
    private function do_post()
    {
        if ($this->page['open_comment'] == 1)
        {
            $comment_id = comment_logic::insert_comment($this->id);
            if ($comment_id > 0)
            {
                $this->page['comment_count'] += 1;
                return $this->pagination->prepare($this->page['comment_count'], COMMENT_COUNT_PER_PAGE);
            }
        }
        return false;
    }

    // prepare action
    // returns: true if prepare successful, otherwise false
    public function prepare()
    {
        // get page by id
        $this->page = page_logic::get_page($this->id);
        if ($this->page != null)
        {
            // redirect page if this page is a post
            if ($this->page['type'] == POST)
                common::redirect_page(sprintf('dispatch.php?action=post&id=%d', $this->id));

            // apply custom theme file
            if ($this->page['theme_file'] != null)
                $this->theme_file = $this->page['theme_file'];

            // do get/post by request method
            switch ($_SERVER['REQUEST_METHOD'])
            {
                case HTTP_GET:
                    return $this->do_get();

                case HTTP_POST:
                    return $this->do_post();
            }
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign pagination vars
            $this->pagination->assign($weblate);

            // assign page variables
            $weblate->assign("page", $this->page);
            $weblate->assign("comments", comment_logic::get_comments($this->id, $this->pagination->current_page - 1, COMMENT_COUNT_PER_PAGE));
            $weblate->assign("floor_base", ($this->pagination->current_page - 1) * COMMENT_COUNT_PER_PAGE);

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>