<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/utilities/pagination.php');

require_once(WEB_ROOT . '/business_logic/post_logic.php');
require_once(WEB_ROOT . '/business_logic/comment_logic.php');
require_once(WEB_ROOT . '/business_logic/category_logic.php');
require_once(WEB_ROOT . '/business_logic/post_category_relationship_logic.php');

// declare class
class post_action extends action
{
    private $id;
    private $post;
    private $pagination;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(THEME_PATH, $theme_file);

        // initialize data members
        $this->id = @intval($_GET['id']);
        $this->pagination = new pagination();
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->id);
        unset($this->post);
        unset($this->pagination);
    }

    // for get request
    // returns: true if successful, otherwise false
    private function do_get()
    {
        if (post_logic::update_read_count($this->id) > 0)
        {
            return $this->pagination->prepare($this->post['comment_count'], COMMENT_COUNT_PER_PAGE);
        }
        return false;
    }
    
    // for post request
    // returns: redirect page if successful, otherwise false
    private function do_post()
    {
        if ($this->post['open_comment'] == 1)
        {
            $comment_id = comment_logic::insert_comment($this->id);
            if ($comment_id > 0)
            {
                $this->post['comment_count'] += 1;
                return $this->pagination->prepare($this->post['comment_count'], COMMENT_COUNT_PER_PAGE);
            }
        }
        return false;
    }

    // prepare action
    // returns: true if prepare successful, otherwise false
    public function prepare()
    {
        // get post by id
        $this->post = post_logic::get_post($this->id);
        if ($this->post != null)
        {
            // redirect page if this post is a page
            if ($this->post['type'] == PAGE)
                common::redirect_page(sprintf('dispatch.php?action=page&id=%d', $this->id));

            // apply custom theme file
            if ($this->post['theme_file'] != null)
                $this->theme_file = $this->post['theme_file'];

            // do get/post by request method
            switch ($_SERVER['REQUEST_METHOD'])
            {
                case HTTP_GET:
                    return $this->do_get();

                case HTTP_POST:
                    return $this->do_post();
            }
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign pagination vars
            $this->pagination->assign($weblate);

            // assign post variables
            $weblate->assign("post", $this->post);
            $weblate->assign("post_categories", post_category_relationship_logic::get_post_categories($this->id));
            $weblate->assign("related_posts", post_logic::get_related_posts($this->id, $this->post['tags']));
            $weblate->assign("comments", comment_logic::get_comments($this->id, $this->pagination->current_page - 1, COMMENT_COUNT_PER_PAGE));

            $weblate->assign("previous_post", post_logic::get_previous_post($this->id));
            $weblate->assign("next_post", post_logic::get_next_post($this->id));

            $weblate->assign("hot_posts", post_logic::get_hot_posts($this->post['category_id']));
            $weblate->assign("floor_base", ($this->pagination->current_page - 1) * COMMENT_COUNT_PER_PAGE);

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>