<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/utilities/pagination.php');

require_once(WEB_ROOT . '/business_logic/post_logic.php');
require_once(WEB_ROOT . '/business_logic/options_logic.php');
require_once(WEB_ROOT . '/business_logic/comment_logic.php');
require_once(WEB_ROOT . '/business_logic/category_logic.php');
require_once(WEB_ROOT . '/business_logic/post_category_relationship_logic.php');

// declare class
class search_action extends action
{
    private $type;
    private $value;
    private $pagination;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(THEME_PATH, $theme_file);

        // initialize data members
        $this->type = $_GET['type'];
        $this->value = urldecode($_GET['value']);
        $this->pagination = new pagination();
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->type);
        unset($this->value);
        unset($this->pagination);
    }

    // for get request
    // returns: true if successful, otherwise false
    private function do_get()
    {
        if ($this->value != null && strlen($this->value) > 0)
        {
            switch ($this->type)
            {
                case TAG:
                    return $this->pagination->prepare(post_logic::get_post_count_by_tag($this->value), POST_COUNT_PER_PAGE);

                case KEYWORD:
                    return $this->pagination->prepare(post_logic::get_post_count_by_keyword($this->value), POST_COUNT_PER_PAGE);
            }
        }
        return false;
    }
    
    // prepare action
    // returns: true if prepare successful, otherwise false
    public function prepare()
    {
        switch ($_SERVER['REQUEST_METHOD'])
        {
            case HTTP_GET:
                return $this->do_get();

            case HTTP_POST:
                common::redirect_page(sprintf("dispatch.php?action=search&type=%s&value=%s", $_POST['type'], urlencode($_POST['value'])));
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign pagination vars
            $this->pagination->assign($weblate);

            // assign variables
            switch ($this->type)
            {
                case TAG:
                    $weblate->assign("posts", post_logic::get_posts_by_tag($this->value, $this->pagination->current_page - 1));
                    break;

                case KEYWORD:
                    $weblate->assign("posts", post_logic::get_posts_by_keyword($this->value, $this->pagination->current_page - 1));
                    break;
            }
            $weblate->assign("hot_posts", post_logic::get_hot_posts($this->id));
            $weblate->assign("recent_comments", comment_logic::get_recent_comments());
            $weblate->assign("options", options_logic::get_options(null));

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>