<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/business_logic/category_logic.php');

// declare class
class categories_action extends action
{
    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(ADMIN_THEME_PATH, $theme_file);
    }

    // for post request
    // returns: true if successful, otherwise false
    private function do_post()
    {
        category_logic::remove_category(@intval($_POST['category_id']));
        common::redirect_page('dispatch.php?action=admin_categories');
    }

    // prepare action
    public function prepare()
    {
        if (parent::get_login_user() != null)
        {
            // do get/post
            switch ($_SERVER['REQUEST_METHOD'])
            {
                case HTTP_GET:
                    return true;

                case HTTP_POST:
                    return $this->do_post();
            }
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>