<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/business_logic/category_logic.php');

// declare class
class category_action extends action
{
    private $id;
    private $category;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(ADMIN_THEME_PATH, $theme_file);

        // initialize data members
        $this->id = @intval($_GET['id']);
    }

    // destructor
    public function __destruct()
    {
        unset($this->id);
        unset($this->category);
    }

    // for post request
    // returns: true if successful, otherwise false
    private function do_post()
    {
        // insert a new category
        if ($this->id == 0)
        {
            if (category_logic::add_category(category_logic::get_model()) > 0)
                common::redirect_page("dispatch.php?action=admin_categories");
        }
        else // update a category
        {
            category_logic::update_category($this->id, category_logic::get_model());
            common::redirect_page("dispatch.php?action=admin_categories");
        }
        return false;
    }

    // prepare action
    public function prepare()
    {
        if ($this->get_login_user() != null)
        {
            // get category by id
            if ($this->id > 0)
                $this->category = category_logic::get_category($this->id);

            // do get/post
            switch ($_SERVER['REQUEST_METHOD'])
            {
                case HTTP_GET:
                    return true;

                case HTTP_POST:
                    return $this->do_post();
            }
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign variables
            $weblate->assign("category", $this->category);

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>