<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/business_logic/comment_logic.php');

// declare class
class comment_action extends action
{
    private $id;
    private $comment;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(ADMIN_THEME_PATH, $theme_file);

        // initialize data members
        $this->id = @intval($_GET['id']);
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->id);
        unset($this->comment);
    }

    // for post request
    // returns: true if successful, otherwise false
    private function do_post()
    {
        if (comment_logic::update_comment($this->id, comment_logic::get_model(false)) >= 0)
        {
            common::redirect_page("dispatch.php?action=admin_comments");
        }
        return false;
    }

    // prepare action
    public function prepare()
    {
        if ($this->get_login_user() != null)
        {
            // get comment by id
            $this->comment = comment_logic::get_comment($this->id);
            if ($this->comment != null)
            {
                // do get/post
                switch ($_SERVER['REQUEST_METHOD'])
                {
                    case HTTP_GET:
                        return true;

                    case HTTP_POST:
                        return $this->do_post();
                }
            }
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign variables
            $weblate->assign("comment", $this->comment);

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>