<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/utilities/pagination.php');
require_once(WEB_ROOT . '/business_logic/comment_logic.php');

// declare class
class comments_action extends action
{
    private $post_id;
    private $pagination;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(ADMIN_THEME_PATH, $theme_file);

        // initialize data members
        $this->post_id = @intval($_GET['post']);
        $this->pagination = new pagination();
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->post_id);
        unset($this->pagination);
    }

    // for get request
    private function do_get()
    {
        $count = comment_logic::get_comment_count($this->post_id);
        return $this->pagination->prepare($count, ADMIN_COMMENT_COUNT_PER_PAGE);
    }

    // for post request
    // returns: true if successful, otherwise false
    private function do_post()
    {
        if (comment_logic::remove_comment(@intval($_POST['comment_id'])) > 0)
        {
            common::redirect_page('dispatch.php?action=admin_comments');
        }
        return false;
    }

    // prepare action
    public function prepare()
    {
        if (parent::get_login_user() != null)
        {
            // do get/post
            switch ($_SERVER['REQUEST_METHOD'])
            {
                case HTTP_GET:
                    return $this->do_get();

                case HTTP_POST:
                    return $this->do_post();
            }
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign vars
            $this->pagination->assign($weblate);
            $weblate->assign('comments', comment_logic::get_comments($this->post_id, $this->pagination->current_page - 1, ADMIN_COMMENT_COUNT_PER_PAGE));

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>