<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/business_logic/page_logic.php');

// declare class
class page_action extends action
{
    private $id;
    private $page;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(ADMIN_THEME_PATH, $theme_file);

        // initialize data members
        $this->id = @intval($_GET['id']);
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->id);
        unset($this->page);
    }

    // for page request
    // returns: true if successful, otherwise false
    private function do_post()
    {
        // insert a new page
        if ($this->id == 0)
        {
            if (page_logic::add_page(page_logic::get_model(true)) > 0)
                common::redirect_page("dispatch.php?action=admin_pages");
        }
        else // update a page
        {
            if (page_logic::update_page($this->id, page_logic::get_model(false)) >= 0)
                common::redirect_page("dispatch.php?action=admin_pages");
        }
        return false;
    }

    // prepare action
    public function prepare()
    {
        if ($this->get_login_user() != null)
        {
            // get page by id
            if ($this->id > 0)
                $this->page = page_logic::get_page($this->id);

            // do get/page
            switch ($_SERVER['REQUEST_METHOD'])
            {
                case HTTP_GET:
                    return true;

                case HTTP_POST:
                    return $this->do_post();
            }
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign variables
            $weblate->assign("page", $this->page);

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>