<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/utilities/pagination.php');
require_once(WEB_ROOT . '/business_logic/page_logic.php');

// declare class
class pages_action extends action
{
    private $pagination;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(ADMIN_THEME_PATH, $theme_file);

        // initialize data members
        $this->pagination = new pagination();
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->pagination);
    }

    // for get request
    // returns: true if successful, otherwise false
    private function do_get()
    {
        $count = page_logic::get_page_count();
        return $this->pagination->prepare($count, ADMIN_POST_COUNT_PER_PAGE);
    }

    // for page request
    // returns: true if successful, otherwise false
    private function do_post()
    {
        if (page_logic::remove_page(@intval($_POST['page_id'])) > 0)
        {
            common::redirect_page('dispatch.php?action=admin_pages');
        }
        return false;
    }

    // prepare action
    public function prepare()
    {
        if (parent::get_login_user() != null)
        {
            // do get/page
            switch ($_SERVER['REQUEST_METHOD'])
            {
                case HTTP_GET:
                    return $this->do_get();

                case HTTP_POST:
                    return $this->do_post();
            }
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign pagination vars
            $this->pagination->assign($weblate);

            // assign page list vars
            $weblate->assign("pages", page_logic::get_pages($this->pagination->current_page - 1));

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>