<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/business_logic/post_logic.php');

// declare class
class post_action extends action
{
    private $id;
    private $post;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(ADMIN_THEME_PATH, $theme_file);

        // initialize data members
        $this->id = @intval($_GET['id']);
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->id);
        unset($this->post);
    }

    // for post request
    // returns: true if successful, otherwise false
    private function do_post()
    {
        // insert a new post
        if ($this->id == 0)
        {
            if (post_logic::add_post(post_logic::get_model(true)) > 0)
                common::redirect_page(sprintf("dispatch.php?action=admin_posts&category=%s", $_POST['category_id']));
        }
        else // update a post
        {
            if (post_logic::update_post($this->id, post_logic::get_model(false), @intval($_POST['category_id'])) >= 0)
                common::redirect_page(sprintf("dispatch.php?action=admin_posts&category=%s", $this->post['category_id']));
        }
        return false;
    }

    // prepare action
    public function prepare()
    {
        if ($this->get_login_user() != null)
        {
            // get post by id
            if ($this->id > 0)
                $this->post = post_logic::get_post($this->id);

            // do get/post
            switch ($_SERVER['REQUEST_METHOD'])
            {
                case HTTP_GET:
                    return true;

                case HTTP_POST:
                    return $this->do_post();
            }
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign variables
            $weblate->assign("post", $this->post);

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>