<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/utilities/pagination.php');

require_once(WEB_ROOT . '/business_logic/post_logic.php');
require_once(WEB_ROOT . '/business_logic/post_category_relationship_logic.php');

// declare class
class posts_action extends action
{
    private $category_id;
    private $pagination;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(ADMIN_THEME_PATH, $theme_file);

        // initialize data members
        $this->category_id = @intval($_GET['category']);
        $this->pagination = new pagination();
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->category_id);
        unset($this->pagination);
    }

    // for get request
    // returns: true if successful, otherwise false
    private function do_get()
    {
        $count = post_category_relationship_logic::get_post_count($this->category_id);
        return $this->pagination->prepare($count, ADMIN_POST_COUNT_PER_PAGE);
    }

    // for post request
    // returns: true if successful, otherwise false
    private function do_post()
    {
        if (post_logic::remove_post(@intval($_POST['post_id'])) > 0)
        {
            common::redirect_page(sprintf('dispatch.php?action=admin_posts&category=%d', $this->category_id));
        }
        return false;
    }

    // prepare action
    public function prepare()
    {
        if (parent::get_login_user() != null)
        {
            // do get/post
            switch ($_SERVER['REQUEST_METHOD'])
            {
                case HTTP_GET:
                    return $this->do_get();

                case HTTP_POST:
                    return $this->do_post();
            }
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign pagination vars
            $this->pagination->assign($weblate);

            // assign post list vars
            $weblate->assign("posts", post_logic::get_posts($this->category_id, $this->pagination->current_page - 1, ADMIN_POST_COUNT_PER_PAGE));

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>