<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/business_logic/user_logic.php');

// declare class
class user_action extends action
{
    private $id;
    private $user;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(ADMIN_THEME_PATH, $theme_file);

        // initialize data members
        $this->id = @intval($_GET['id']);
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->id);
        unset($this->user);
    }

    // for post request
    // returns: true if successful, otherwise false
    private function do_post()
    {
        // add a new user
        if ($this->id == 0)
        {
            if (user_logic::add_user(user_logic::get_model(true)) > 0)
                common::redirect_page("dispatch.php?action=admin_users");
        }
        else // update a user
        {
            if (user_logic::update_user($this->id, user_logic::get_model(false)) >= 0)
                common::redirect_page("dispatch.php?action=admin_users");
        }
        return false;
    }

    // prepare action
    public function prepare()
    {
        if ($this->get_login_user() != null)
        {
            // get user by id
            if ($this->id > 0)
                $this->user = user_logic::get_user($this->id);

            // do get/post
            switch ($_SERVER['REQUEST_METHOD'])
            {
                case HTTP_GET:
                    return true;

                case HTTP_POST:
                    return $this->do_post();
            }
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign variables
            $weblate->assign("user", $this->user);

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>