<?php

// include files
require_once(WEB_ROOT . '/actions/action.php');
require_once(WEB_ROOT . '/utilities/pagination.php');
require_once(WEB_ROOT . '/business_logic/user_logic.php');

// declare class
class users_action extends action
{
    private $pagination;

    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        // call parent constructor
        parent::__construct(ADMIN_THEME_PATH, $theme_file);

        // initialize data members
        $this->pagination = new pagination();
    }
    
    // destructor
    public function __destruct()
    {
        unset($this->pagination);
    }

    // for get request
    private function do_get()
    {
        $count = user_logic::get_user_count();
        return $this->pagination->prepare($count, ADMIN_USER_COUNT_PER_PAGE);
    }

    // for post request
    // returns: true if successful, otherwise false
    private function do_post()
    {
        if (user_logic::remove_user(@intval($_POST['user_id'])) > 0)
        {
            common::redirect_page('dispatch.php?action=admin_users');
        }
        return false;
    }

    // prepare action
    public function prepare()
    {
        if (parent::get_login_user() != null)
        {
            // do get/post
            switch ($_SERVER['REQUEST_METHOD'])
            {
                case HTTP_GET:
                    return $this->do_get();

                case HTTP_POST:
                    return $this->do_post();
            }
        }
        return false;
    }

    // execute action
    public function execute()
    {
        $weblate = parent::execute();
        if ($weblate != null)
        {
            // assign vars
            $this->pagination->assign($weblate);
            $weblate->assign('users', user_logic::get_users($this->pagination->current_page - 1));

            // compile theme and show it
            $weblate->compile();
            $weblate->show();
        }
    }
}

?>