// validate text length of input field
// field_id: field id
// tip_field_id: tip tield id
// min_length: minimum length
// max_length: maxmum length
function validate_field_length(field_id, tip_field_id, min_length, max_length)
{
    // restore text color
    $(tip_field_id).css("color", "#999");

    // set the tip text in red
    var length = $(field_id).val().length;
    if (length < min_length || length > max_length)
    {
        $(tip_field_id).css("color", "#f00");
        return false;
    }
    return true;
}

// validate text format of input field
// field_id: field id
// tip_field_id: tip tield id
// regex_text: regex express text
function validate_field_format(field_id, tip_field_id, regex_text)
{
    // restore text color
    $(tip_field_id).css("color", "#999");

    // set the tip text in red
    var regex = new RegExp(regex_text);
    if (!regex.test($(field_id).val()))
    {
        $(tip_field_id).css("color", "#f00");
        return false;
    }
    return true;
}