<?php

// include files
require_once(WEB_ROOT . '/business_logic/post_logic.php');
require_once(WEB_ROOT . '/data_access/category_access.php');

// declare class
class category_logic
{
    // make category model from post
    // returns: category model
    public static function get_model()
    {
        // make category data
        $category = array("name" => $_POST['name'],
            "display_order" => $_POST['display_order'],
            "parent_id" => $_POST['parent_id'],
            "description" => $_POST['description'],
            "meta" => $_POST['meta']);
        return $category;
    }

    // make categories into a hash map
    // $categories: category array
    // returns: a hash map with categories
    private static function make_categories_map($categories)
    {
        $categoryMap = array();
        foreach ($categories as $category)
        {
            $id = $category['id'];
            $categoryMap[$id] = $category;
        }
        return $categoryMap;
    }

    // get all categories
    // returns: a hash map contains all categories
    public static function get_all_categories()
    {
        $categories = category_access::get_all_categories();
        $categories = common::attach_meta_values_into_rows($categories);
        return self::make_categories_map($categories);
    }

    // get get direct sub-categories
    // $id: category id
    // returns: sub categories in arrary
    public static function get_sub_categories($id)
    {
        $categories = category_access::get_sub_categories($id);
        $categories = common::attach_meta_values_into_rows($categories);
        return self::make_categories_map($categories);
    }

    // add a category
    // $model: category model
    // returns: category id if successful, otherwise false
    public static function add_category($model)
    {
        return category_access::add_category($model);
    }

    // get category
    // $id: category id
    // returns: category in array
    public static function get_category($id)
    {
        $category = category_access::get_category($id);
        return common::attach_meta_values_into_row($category);
    }

    // get category count
    // returns: category count
    public static function get_category_count()
    {
        return category_access::get_category_count();
    }

    // remove category
    // $id: category id
    public static function remove_category($id)
    {
        // get category by id
        $category = self::get_category($id);
        if ($category != null && $category['post_count'] <= 0)
        {
            // remove category
            category_access::remove_category($id);

            // remove all sub categories
            $sub_categories = self::get_sub_categories($id);
            foreach ($sub_categories as $sub_category)
                self::remove_category($sub_category['id']);
        }
    }

    // update category
    // $id: category id
    // $model: new category model
    public static function update_category($id, $model)
    {
        // update post count of categories
        $category = self::get_category($id);
        $parent_category_changed = ($category['parent_id'] != $model['parent_id']);
        if ($parent_category_changed == true)
        {
            // update post count for old parent
            self::update_post_count($category['parent_id'], -$category['post_count']);

            // update post count for new parent
            self::update_post_count($model['parent_id'], $category['post_count']);
        }

        // update category information
        if (category_access::update_category($id, $model) > 0 && $parent_category_changed)
        {
            // reconstruction all post-category relationships
            for ($i = 0; $i < 100000; $i++)
            {
                // get posts by category id
                $posts = post_logic::get_posts($id, $i);
                if (count($posts) == 0)
                    break;

                // update post-category relationships
                foreach ($posts as $post)
                {
                    post_category_relationship_logic::remove_relationships($post['id']);
                    post_category_relationship_logic::add_relationships($post['id'], $id);
                }
            }
        }
    }

    // update post count
    // $id: category id
    // $delta: delta to added
    public static function update_post_count($id, $delta = 1)
    {
        while ($id >= 0)
        {
            // update post count
            category_access::update_post_count($id, $delta);

            // for update parent category
            $category = self::get_category($id);
            $id = ($category != null) ? $category['parent_id'] : -1;
        }
    }
}

?>