<?php

// include files
require_once(WEB_ROOT . '/utilities/common.php');
require_once(WEB_ROOT . '/business_logic/post_logic.php');
require_once(WEB_ROOT . '/data_access/comment_access.php');

// declare class
class comment_logic
{
    // make comment model from post
    // $is_add: is add a comment ?
    // returns: comment model
    public static function get_model($is_add)
    {
        // make comment model
        $comment = array("post_id" => $_POST['post_id'], 
            "replier_name" => $_POST['replier_name'], 
            "replier_email" => $_POST['replier_email'], 
            "replier_url" => $_POST['replier_url'], 
            "content" => $_POST['content'], 
            "meta" => $_POST['meta']);

        // for add comment
        if ($is_add == true)
        {
            $comment["replier_ip"] = $_SERVER["REMOTE_ADDR"];
            $comment["create_time"] = "now()";
        }
        return $comment;
    }

    // get comment
    // $id: comment id
    // returns: comment in a record
    public static function get_comment($id)
    {
        $comment = comment_access::get_comment($id);
        return common::attach_meta_values_into_row($comment);
    }

    // insert a comment
    // $post_id: post id
    // returns: comment id if successful, otherwise 0
    public static function insert_comment($post_id)
    {
        $comment = self::get_model(true);
        $record_id = comment_access::insert_comment($comment);
        if ($record_id > 0)
        {
            post_logic::update_comment_count($post_id);
        }
        return $record_id;
    }

    // get comments
    // $post_id: post id, 0 to get all comments
    // $page: page index, based on zero
    // $count_per_page: comment count per page
    // returns: comments in array
    public static function get_comments($post_id, $page, $count_per_page)
    {
        $comments = comment_access::get_comments($post_id, $page, $count_per_page);
        return common::attach_meta_values_into_rows($comments);
    }

    // get comment count
    // $post_id: post id, 0 to get all comment count
    // returns: post count
    public static function get_comment_count($post_id)
    {
        return comment_access::get_comment_count($post_id);
    }

    // update comment
    // $id: comment id
    // $model: comment model
    // returns: affected row count
    public static function update_comment($id, $model)
    {
        return comment_access::update_comment($id, $model);
    }

    // get recent comments
    // returns: comments in array
    public static function get_recent_comments()
    {
        $comments = comment_access::get_recent_comments(RECENT_COMMENT_COUNT);
        return common::attach_meta_values_into_rows($comments);
    }
    
    // remove comment
    // $id: comment id
    // returns: affected row count
    public static function remove_comment($id)
    {
        $comment = self::get_comment($id);
        if ($comment != null)
        {
            post_logic::update_comment_count($comment['post_id'], -1);
            return comment_access::remove_comment($id);
        }
        return 0;
    }

    // remove comments by post
    // $post_id: post id
    // returns: affected row count
    public static function remove_comment_by_post($post_id)
    {
        return comment_access::remove_comment_by_post($post_id);
    }
}

?>