<?php

// include files
require_once(WEB_ROOT . '/utilities/common.php');
require_once(WEB_ROOT . '/data_access/page_access.php');
require_once(WEB_ROOT . '/business_logic/comment_logic.php');

// declare class
class page_logic
{
    // make page model from page
    // $is_add: is add a page?
    // returns: page model
    public static function get_model($is_add)
    {
        // make page data
        $page = array("title" => $_POST['title'],
            "summary" => $_POST["summary"],
            "content" => $_POST['content'],
            "type" => 0,
            "sticky" => $_POST['sticky'],
            "open_comment" => $_POST['open_comment'],
            "tags" => $_POST['tags'],
            "meta" => $_POST['meta'],
            "update_time"=>"now()");

        // add user id and create time for add a page
        if ($is_add == true)
        {
            session_start();
            $page['user_id'] = $_SESSION[LOGIN_USER]['id'];
            $page['create_time'] = "now()";
        }

        return $page;
    }

    // get page
    // $id: page id
    // returns: page in array
    public static function get_page($id)
    {
        $page = page_access::get_page($id);
        return common::attach_meta_values_into_row($page);
    }

    // add a page
    // $model: page model
    // returns: new page id if successful, otherwise 0
    public static function add_page($model)
    {
        return page_access::add_page($model);
    }

    // remove page by id
    // $id: page id
    // returns: affected row count
    public static function remove_page($id)
    {
        comment_logic::remove_comment_by_post($id);
        return page_access::remove_page($id);
    }
    
    // update page
    // $id: page id
    // $model: page model
    // returns: affected row count
    public static function update_page($id, $model)
    {
        return page_access::update_page($id, $model);
    }

    // get pages
    // $page: page index, based on zero
    // returns: pages in array
    public static function get_pages($page)
    {
        $pages = page_access::get_pages($page, POST_COUNT_PER_PAGE);
        return common::attach_meta_values_into_rows($pages);
    }

    // get page count
    // returns: page count
    public static function get_page_count()
    {
        return page_access::get_page_count();
    }

    // update page read count
    // $id: page id
    // returns: affected row count
    public static function update_read_count($id)
    {
        return page_access::update_read_count($id);
    }

    // update page comment count
    // $id: page id
    // $delta: delta value
    // returns: affected row count
    public static function update_comment_count($id, $delta = 1)
    {
        return page_access::update_comment_count($id, $delta);
    }
}

?>