<?php

// include files
require_once(WEB_ROOT . '/business_logic/category_logic.php');
require_once(WEB_ROOT . '/data_access/post_category_relationship_access.php');

// declare class
class post_category_relationship_logic
{
    // get post count
    // $category: category id, null to get all post count
    // returns: post count
    public static function get_post_count($category)
    {
        return post_category_relationship_access::get_post_count($category);
    }

    // get post categories
    // $post: post id
    // returns: categories in arrary
    public static function get_post_categories($post)
    {
        return post_category_relationship_access::get_post_categories($post);
    }

    // add post-category relationships
    // $post_id: post id
    // $catgory_id: category id
    public static function add_relationships($post_id, $category_id)
    {
        $original_id = $category_id;
        while ($category_id >= 0)
        {
            // add relationship
            $is_direct = ($category_id == $original_id) ? 1 : 0;
            $relationship = array("post_id" => $post_id, "category_id" => $category_id, "is_direct" => $is_direct);
            post_category_relationship_access::add_relationship($relationship);

            // for parent category relationship
            $category = category_logic::get_category($category_id);
            $category_id = $category['parent_id'];
        }
    }

    // remove relationships
    // $post_id: post id
    // returns: effective row count
    public static function remove_relationships($post_id)
    {
        return post_category_relationship_access::remove_relationships($post_id);
    }
}

?>