<?php

// include files
require_once(WEB_ROOT . '/utilities/common.php');
require_once(WEB_ROOT . '/data_access/post_access.php');

require_once(WEB_ROOT . '/business_logic/comment_logic.php');
require_once(WEB_ROOT . '/business_logic/category_logic.php');
require_once(WEB_ROOT . '/business_logic/post_category_relationship_logic.php');

// declare class
class post_logic
{
    // make post model from post
    // $is_add: is add a post?
    // returns: post model
    public static function get_model($is_add)
    {
        // make post data
        $post = array("title" => $_POST['title'],
            "summary" => $_POST["summary"],
            "content" => $_POST['content'],
            "type" => 1,
            "sticky" => $_POST['sticky'],
            "open_comment" => $_POST['open_comment'],
            "tags" => $_POST['tags'],
            "meta" => $_POST['meta'],
            "update_time"=>"now()");

        // add user id and create time for add a post
        if ($is_add == true)
        {
            session_start();
            $post['user_id'] = $_SESSION[LOGIN_USER]['id'];
            $post['create_time'] = "now()";
        }

        return $post;
    }

    // get post
    // $id: post id
    // returns: post in array
    public static function get_post($id)
    {
        $post = post_access::get_post($id);
        return common::attach_meta_values_into_row($post);
    }

    // add a post
    // $model: post model
    // returns: new post id if successful, otherwise 0
    public static function add_post($model)
    {
        // get post model and add it
        $post_id = post_access::add_post($model);
        if ($post_id > 0)
        {
            // update post count for category
            $category_id = @intval($_POST['category_id']);
            category_logic::update_post_count($category_id, 1);

            // add post-category relationships
            post_category_relationship_logic::add_relationships($post_id, $category_id);
        }
        return $post_id;
    }

    // remove post by id
    // $id: post id
    // returns: affected row count if successful, otherwise -1
    public static function remove_post($id)
    {
        $post = self::get_post($id);
        if ($post != null)
        {
            comment_logic::remove_comment_by_post($id);
            post_category_relationship_logic::remove_relationships($id);
            category_logic::update_post_count($post['category_id'], -1);
            return post_access::remove_post($id);
        }
        return -1;
    }
    
    // update post
    // $id: post id
    // $model: post model
    // $new_category_id: new category id
    // returns: affected row count
    public static function update_post($id, $model, $new_category_id)
    {
        // presave old category id
        $post = self::get_post($id);
        $old_category_id = $post['category_id'];

        // update post
        $affected_row_count = post_access::update_post($id, $model);
        if ($affected_row_count > 0)
        {
            // update post count for category
            category_logic::update_post_count($old_category_id, -1);
            category_logic::update_post_count($new_category_id, 1);

            // remove relationships and add new relationships
            post_category_relationship_logic::remove_relationships($id);
            post_category_relationship_logic::add_relationships($id, $new_category_id);
        }
        return $affected_row_count;
    }

    // get posts
    // $category: category id
    // $page: page index, based on zero
    // returns: posts in array
    public static function get_posts($category, $page)
    {
        $posts = post_access::get_posts($category, $page, POST_COUNT_PER_PAGE);
        return common::attach_meta_values_into_rows($posts);
    }

    // get posts by keyword
    // $keyword: keyword to search
    // $page: page index, based on zero
    // returns: posts in array
    public static function get_posts_by_keyword($keyword, $page)
    {
        $posts = post_access::get_posts_by_keyword($keyword, $page, POST_COUNT_PER_PAGE);
        return common::attach_meta_values_into_rows($posts);
    }

    // get post count by keyword
    // $keyword: keyword to search
    // returns: post count
    public static function get_post_count_by_keyword($keyword)
    {
        return post_access::get_post_count_by_keyword($keyword);
    }

    // get posts by tag
    // $keyword: tag to search
    // $page: page index, based on zero
    // returns: posts in array
    public static function get_posts_by_tag($tag, $page)
    {
        $posts = post_access::get_posts_by_tag($tag, $page, POST_COUNT_PER_PAGE);
        return common::attach_meta_values_into_rows($posts);
    }

    // get post count by tag
    // $tag: tag to search
    // returns: post count
    public static function get_post_count_by_tag($tag)
    {
        return post_access::get_post_count_by_tag($tag);
    }

    // get hot posts
    // $category: category id, 0 to get recommend posts in global
    // returns: posts in array
    public static function get_hot_posts($category)
    {
        $posts = post_access::get_hot_posts($category, HOT_POST_COUNT, HOT_POST_IN_HOUR);
        return common::attach_meta_values_into_rows($posts);
    }

    // get related posts
    // $id: post id
    // $tags: tags string, such as .Net,C#,Ajax,...
    // returns: related posts
    public static function get_related_posts($id, $tags)
    {
        if (strlen(trim($tags)) > 0)
        {
            $tag_array = explode(',', trim($tags));
            $posts = post_access::get_related_posts($id, $tag_array);
            return common::attach_meta_values_into_rows($posts);
        }
        return null;
    }
    
    // get privious post
    // $id: post id
    // returns: previous post
    public static function get_previous_post($id)
    {
        $post = post_access::get_previous_post($id);
        return common::attach_meta_values_into_row($post);
    }

    // get next post
    // $id: post id
    // returns: next post
    public static function get_next_post($id)
    {
        $post = post_access::get_next_post($id);
        return common::attach_meta_values_into_row($post);
    }
    
    // update post read count
    // $id: post id
    // returns: affected row count
    public static function update_read_count($id)
    {
        return post_access::update_read_count($id);
    }

    // update post comment count
    // $id: post id
    // $delta: delta value
    // returns: affected row count
    public static function update_comment_count($id, $delta = 1)
    {
        return post_access::update_comment_count($id, $delta);
    }
}

?>