<?php

// include files
require_once(WEB_ROOT . '/data_access/user_access.php');

// declare class
class user_logic
{
    // make user model from post
    // $is_add: is add a user ?
    // returns: user model
    public static function get_model($is_add)
    {
        // make user model
        $user = array("name" => $_POST['name'], 
            "sex" => $_POST['sex'], 
            "email" => $_POST['email'], 
            "url" => $_POST['url'], 
            "meta" => $_POST['meta']);

        // set password if it isn't empty
        if (strlen($_POST['password']) > 0)
            $user["password"] = md5($_POST['password']);

        // for add user
        if ($is_add == true)
            $user["register_time"] = "now()";

        return $user;
    }

    // get user
    // $id: user id
    // returns: user model
    public static function get_user($id)
    {
        $user = user_access::get_user($id);
        return common::attach_meta_values_into_row($user);
    }
    
    // get users
    // $page: page index, based on zero
    // returns: users in array
    public static function get_users($page)
    {
        $users = user_access::get_users($page, ADMIN_USER_COUNT_PER_PAGE);
        return common::attach_meta_values_into_rows($users);
    }

    // user login
    // $name: user name
    // $password: password
    // returns: user information in an record if successful, otherwise null
    public static function user_login($name, $password)
    {
        return user_access::user_login($name, $password);
    }
    
    // get user count
    // returns: user count
    public static function get_user_count()
    {
        return user_access::get_user_count();
    }
    
    // add a new user
    // $user: user model
    // returns: user's id
    public static function add_user($user)
    {
        return user_access::add_user($user);
    }

    // remove user by id
    // $id: user id
    // returns: affected row count
    public static function remove_user($id)
    {
        return user_access::remove_user($id);
    }
    
    // update user
    // $id: user id
    // $user: user model
    // returns: affected row count
    public static function update_user($id, $user)
    {
        return user_access::update_user($id, $user);
    }
}

?>