<?php

// include files
require_once(WEB_ROOT . '/utilities/database.php');

// declare class
class category_access
{
    // get all categories
    // returns: all categories
    public static function get_all_categories()
    {
        $sql = "select * from categories order by display_order asc";
        return database::get_instance()->query_records($sql);
    }

    // get get sub-categories
    // $parent: parent category id
    // returns: category arrary
    public static function get_sub_categories($parent)
    {
        $sql = sprintf("select * from categories where parent_id = %d order by display_order asc", $parent);
        return database::get_instance()->query_records($sql);
    }

    // get category
    // $id: category id
    // returns: category in a record
    public static function get_category($id)
    {
        $sql = sprintf("select * from categories where id = %d", $id);
        return database::get_instance()->query_first_record($sql);
    }

    // get category count
    // returns: category count
    public static function get_category_count()
    {
        $sql = "select count(*) as scalar from categories";
        return database::get_instance()->query_scalar($sql);
    }
    
    // add a category
    // $category: category data
    // returns: category id if successful, otherwise false
    public static function add_category($category)
    {
        return database::get_instance()->query_insert("categories", $category);
    }
    
    // remove category
    // $id: category id
    // returns: affected row count
    public static function remove_category($id)
    {
        $sql = sprintf("delete from categories where id = %d", $id);
        return database::get_instance()->execute_sql($sql);
    }

    // update category
    // $id: category id
    // $category: category data
    // returns: affected row count
    public static function update_category($id, $category)
    {
        $where = sprintf(" id = %d ", $id);
        return database::get_instance()->query_update("categories", $category, $where);
    }
    
    // update post count
    // $id: category id
    // $delta: delta to added
    // returns: effective row count
    public static function update_post_count($id, $delta)
    {
        $sql = sprintf("update categories set post_count = post_count + (%d) where id = %d", $delta, $id);
        return database::get_instance()->execute_sql($sql);
    }
}

?>