<?php

// include files
require_once(WEB_ROOT . '/utilities/database.php');

// declare class
class comment_access
{
    // get comment
    // $id: comment id
    // returns: comment in a record
    public static function get_comment($id)
    {
        $sql = sprintf("select * from comments where id = %s", $id);
        return database::get_instance()->query_first_record($sql);
    }

    // insert a comment
    // $comment: comment to insert
    // returns: record id if successful, otherwise 0
    public static function insert_comment($comment)
    {
        return database::get_instance()->query_insert("comments", $comment);
    }

    // update comment
    // $id: comment id
    // $comment: comment model
    // returns: affected row count
    public static function update_comment($id, $comment)
    {
        $where = sprintf(" id = %d ", $id);
        return database::get_instance()->query_update('comments', $comment, $where);
    }

    // get comments
    // $post_id: post id, 0 to get all comments
    // $page: page index, based on zero
    // $count_per_page: comment count per page
    // returns: comments in array
    public static function get_comments($post_id, $page, $count_per_page)
    {
        // make sql statement and execute it
        $sql = ($post_id != 0) ?
            sprintf("select * from comments where post_id = %d order by create_time %s limit %d, %d", $post_id, (COMMENT_ASCENDING_ORDER ? "asc" : "desc"), $page * $count_per_page, $count_per_page) :
            sprintf("select * from comments order by create_time desc limit %d, %d", $page * $count_per_page, $count_per_page);

        return database::get_instance()->query_records($sql);
    }

    // get comment count
    // $post_id: post id, 0 to get all comment count
    // returns: comment count
    public static function get_comment_count($post_id)
    {
        $sql = ($post_id != 0) ? 
            sprintf("select count(*) as scalar from comments where post_id = %d", $post_id) : 
            "select count(*) as scalar from comments";

        return database::get_instance()->query_scalar($sql);
    }

    // get recent comments
    // $count: comments count
    // returns: comments in array
    public static function get_recent_comments($count)
    {
        $sql = sprintf("select * from comments order by create_time desc limit 0, %d", $count);
        return database::get_instance()->query_records($sql);
    }

    // remove comment
    // $id: comment id
    // returns: affected row count
    public static function remove_comment($id)
    {
        $sql = sprintf("delete from comments where id = %d", $id);
        return database::get_instance()->execute_sql($sql);
    }

    // remove comments by post
    // $post_id: post id
    // returns: affected row count
    public static function remove_comment_by_post($post_id)
    {
        $sql = sprintf("delete from comments where post_id = %d", $post_id);
        return database::get_instance()->execute_sql($sql);
    }
}

?>