<?php

// include files
require_once(WEB_ROOT . '/utilities/database.php');

// declare class
class page_access
{
    // get page
    // $id: page id
    // returns: page in a record
    public static function get_page($id)
    {
        $sql = sprintf("select * from posts where id = %d", $id);
        return database::get_instance()->query_first_record($sql);
    }

    // add a page
    // $page: page data
    // returns: new page id if successful, otherwise 0
    public static function add_page($page)
    {
        return database::get_instance()->query_insert("posts", $page);
    }

    // remove page by id
    // $id: page id
    // returns: affected row count
    public static function remove_page($id)
    {
        $sql = sprintf("delete from posts where id = %d", $id);
        return database::get_instance()->execute_sql($sql);
    }
    
    // update page
    // $id: page id
    // $page: page data
    // returns: affected row count
    public static function update_page($id, $page)
    {
        $where = sprintf(" id = %d ", $id);
        return database::get_instance()->query_update("posts", $page, $where);
    }

    // get pages
    // $page: page index, based on zero
    // $count_per_page: page count per page
    // returns: pages in array
    public static function get_pages($page, $count_per_page)
    {
        $sql = sprintf("select * from posts where type = 0 order by sticky desc, create_time desc limit %d, %d", $page * $count_per_page, $count_per_page);
        return database::get_instance()->query_records($sql);
    }
    
    // get page count
    // returns: page count
    public static function get_page_count()
    {
        $sql = "select count(*) as scalar from posts where type = 0";
        return database::get_instance()->query_scalar($sql);
    }

    // update page read count
    // $id: page id
    // returns: affected row count
    public static function update_read_count($id)
    {
        $sql = sprintf("update posts set read_count = read_count + 1 where id = %d", $id);
        return database::get_instance()->execute_sql($sql);
    }
}

?>