<?php

// include files
require_once(WEB_ROOT . '/utilities/database.php');

// declare class
class post_access
{
    // get post
    // $id: post id
    // returns: post in a record
    public static function get_post($id)
    {
        $sql = sprintf("select p.*, pcr.category_id from posts as p left join post_category_relationships as pcr on p.id = pcr.post_id where p.id = %d order by pcr.is_direct desc limit 0, 1", $id);
        return database::get_instance()->query_first_record($sql);
    }

    // add a post
    // $post: post data
    // returns: new post id if successful, otherwise 0
    public static function add_post($post)
    {
        return database::get_instance()->query_insert("posts", $post);
    }
    
    // remove post by id
    // $id: post id
    // returns: affected row count
    public static function remove_post($id)
    {
        $sql = sprintf("delete from posts where id = %d", $id);
        return database::get_instance()->execute_sql($sql);
    }
    
    // update post
    // $id: post id
    // $post: post data
    // returns: affected row count
    public static function update_post($id, $post)
    {
        $where = sprintf(" id = %d ", $id);
        return database::get_instance()->query_update("posts", $post, $where);
    }

    // get posts
    // $category: category id
    // $page: page index, based on zero
    // $count_per_page: post count per page
    // returns: posts in array
    public static function get_posts($category, $page, $count_per_page)
    {
        $sql = ($category != 0) ? 
            sprintf("select p.*, %d as category_id from posts as p left join post_category_relationships as pcr on p.id = pcr.post_id where p.type = 1 and pcr.category_id = %d order by p.sticky desc, p.create_time desc limit %d, %d", $category, $category, $page * $count_per_page, $count_per_page) : 
            sprintf("select p.*, pcr.category_id from posts as p left join post_category_relationships as pcr on p.id = pcr.post_id where p.type = 1 and pcr.is_direct = 1 order by p.sticky desc, p.create_time desc limit %d, %d", $page * $count_per_page, $count_per_page);
        return database::get_instance()->query_records($sql);
    }

    // get posts by keyword
    // $keyword: keyword to search
    // $page: page index, based on zero
    // $count_per_page: post count per page
    // returns: posts in array
    public static function get_posts_by_keyword($keyword, $page, $count_per_page)
    {
        $sql = sprintf("select * from posts where type = 1 and (title like '%%%s%%' or content like '%%%s%%') order by create_time desc limit %d, %d", $keyword, $keyword, $page * $count_per_page, $count_per_page);
        return database::get_instance()->query_records($sql);
    }
    
    // get post count by keyword
    // $keyword: keyword string
    // returns: post count
    public static function get_post_count_by_keyword($keyword)
    {
        $sql = sprintf("select count(*) as scalar from posts where type = 1 and (title like '%%%s%%' or content like '%%%s%%')", $keyword, $keyword);
        return database::get_instance()->query_scalar($sql);
    }

    // get posts by tag
    // $tag: tag to search
    // $page: page index, based on zero
    // $count_per_page: post count per page
    // returns: posts in array
    public static function get_posts_by_tag($tag, $page, $count_per_page)
    {
        $sql = sprintf("select * from posts where type = 1 and (tags like '%%%s%%') order by create_time desc limit %d, %d", $tag, $page * $count_per_page, $count_per_page);
        return database::get_instance()->query_records($sql);
    }

    // get post count by tag
    // $tag tag string
    // returns: post count
    public static function get_post_count_by_tag($tag)
    {
        $sql = sprintf("select count(*) as scalar from posts where type = 1 and (tags like '%%%s%%')", $tag);
        return database::get_instance()->query_scalar($sql);
    }

    // get hot posts
    // $category: category id, 0 to get recommend posts in global
    // $count: post count
    // $in_hours: posts in hours to get
    // returns: posts in array
    public static function get_hot_posts($category, $count, $in_hours)
    {        
        // make sql statement and execute it
        $sql = ($category != null) ?
            sprintf("select * from posts, post_category_relationships as pcr where pcr.category_id = %d and posts.id = pcr.post_id and posts.type = 1 and posts.create_time > date_sub(now(), interval %d hour) order by posts.comment_count desc limit 0, %d", $category, $in_hours, $count) :
            sprintf("select * from posts where type = 1 and posts.create_time > date_sub(now(), interval %d hour) order by comment_count desc limit 0, %d", $in_hours, $count);
        return database::get_instance()->query_records($sql);
    }
    
    // get related posts
    // $id: post id
    // $tags: tag array
    // returns: related posts
    public static function get_related_posts($id, $tags)
    {
        // make search condition
        $search = null;
        foreach ($tags as $tag)
        {
            if ($search == null)
                $search = sprintf("tags like '%%%s%%'", $tag);
            else
                $search .= sprintf(" or tags like '%%%s%%'", $tag);
        }
        
        // make sql string and execute it
        $sql = sprintf("select * from posts where type = 1 and (%s) and id != %d order by create_time desc limit 0, %d", $search, $id, RELATED_POST_COUNT);
        return database::get_instance()->query_records($sql);
    }

    // get privious post
    // $id: post id
    // returns: previous post
    public static function get_previous_post($id)
    {
        $sql = sprintf("select (%s-id) as delta, id, title, read_count, comment_count from posts where id < %s and type = 1 order by delta asc limit 0, 1", $id, $id);
        return database::get_instance()->query_first_record($sql);
    }

    // get next post
    // $id: post id
    // returns: next post
    public static function get_next_post($id)
    {
        $sql = sprintf("select (id-%s) as delta, id, title, read_count, comment_count from posts where id > %s and type = 1 order by delta asc limit 0, 1", $id, $id);
        return database::get_instance()->query_first_record($sql);
    }

    // update post read count
    // $id: post id
    // returns: affected row count
    public static function update_read_count($id)
    {
        $sql = sprintf("update posts set read_count = read_count + 1 where id = %s", $id);
        return database::get_instance()->execute_sql($sql);
    }

    // update post comment count
    // $id: post id
    // $delta: delta value
    // returns: affected row count
    public static function update_comment_count($id, $delta = 1)
    {
        $sql = sprintf("update posts set comment_count = comment_count + (%d) where id = %s", $delta, $id);
        return database::get_instance()->execute_sql($sql);
    }
}

?>