<?php

// include files
require_once(WEB_ROOT . '/utilities/database.php');

// declare class
class post_category_relationship_access
{
    // get post count
    // $category: category id, null to get all post count
    // returns: post count
    public static function get_post_count($category)
    {
        $sql = ($category != 0) ? 
            sprintf("select count(*) as scalar from post_category_relationships where category_id = %d", $category) : 
            "select count(*) as scalar from posts, post_category_relationships as pcr where pcr.is_direct = 1 and posts.id = pcr.post_id";
        return database::get_instance()->query_scalar($sql);
    }

    // get post categories
    // $post: post id
    // returns: categories in arrary
    public static function get_post_categories($post)
    {
        $sql = sprintf("select categories.* from post_category_relationships as bcr, categories where pcr.post_id = %d and pcr.category_id = categories.id", $post);
        return database::get_instance()->query_records($sql);
    }
    
    // add a relationship
    // $relationship: relationship to insert
    // returns: relationship id if successful, otherwise false
    public static function add_relationship($relationship)
    {
        return database::get_instance()->query_insert("post_category_relationships", $relationship);
    }
    
    // remove relationships
    // $post_id: post id
    // returns: effective row count
    public static function remove_relationships($post_id)
    {
        $sql = sprintf("delete from post_category_relationships where post_id = %d", $post_id);
        return database::get_instance()->execute_sql($sql);
    }
}

?>