<?php

// include files
require_once(WEB_ROOT . '/utilities/database.php');

// declare class
class user_access
{
    // get user
    // $id: user id
    // returns: user model
    public static function get_user($id)
    {
        $sql = sprintf("select * from users where id = %d", $id);
        return database::get_instance()->query_first_record($sql);
    }

    // get users
    // $page: page index, based on zero
    // $count_per_page: user count per page
    // returns: users in array
    public static function get_users($page, $count_per_page)
    {
        $sql = sprintf("select * from users order by register_time asc limit %d, %d", $page * $count_per_page, $count_per_page);
        return database::get_instance()->query_records($sql);
    }
    
    // user login
    // $name: user name
    // $password: password
    // returns: user information in an record if successful, otherwise null
    public static function user_login($name, $password)
    {
        $sql = sprintf("select * from users where name = '%s' and password = '%s'", $name, $password);
        return database::get_instance()->query_first_record($sql);
    }

    // get user count
    // returns: user count
    public static function get_user_count()
    {
        $sql = "select count(*) as scalar from users";
        return database::get_instance()->query_scalar($sql);
    }

    // add a new user
    // $user: user model
    // returns: user's id
    public static function add_user($user)
    {
        return database::get_instance()->query_insert("users", $user);
    }

    // remove user by id
    // $id: user id
    // returns: affected row count
    public static function remove_user($id)
    {
        $sql = sprintf("delete from users where id = %d", $id);
        return database::get_instance()->execute_sql($sql);
    }

    // update user
    // $id: user id
    // $user: user model
    // returns: affected row count
    public static function update_user($id, $user)
    {
        $where = sprintf(" id = %d ", $id);
        return database::get_instance()->query_update('users', $user, $where);
    }
}

?>