<?php

// description: dispatch requests to actions
//      author: fanwensheng
//         msn: fanwensheng@live.com
//     address: hefei, anhui province
//   copyright: 2009~2010 all rights reserved

// include config file
require_once('web.config');

// define constants
define("WEPRESS", true);
define("WEB_ROOT", str_replace("\\", "/", dirname(__FILE__)));

define("THEME_PATH", "themes/" . THEME_NAME);
define("ADMIN_THEME_PATH", "admin/themes/" . ADMIN_THEME_NAME);

// dispatch actions
$action = null;
switch ($_GET['action'])
{
    // public actions
    case null:
    case 'category':
        require 'actions/category_action.php';
        $action = new category_action("category.html");
        break;

    case 'post':
        require 'actions/post_action.php';
        $action = new post_action("post.html");
        break;

    case 'search':
        require 'actions/search_action.php';
        $action = new search_action("search.html");
        break;

    case 'page':
        require 'actions/page_action.php';
        $action = new page_action("page.html");
        break;

    case 'login':
        require 'actions/login_action.php';
        $action = new login_action("login.html");
        break;

    case 'logout':
        require 'actions/logout_action.php';
        $action = new logout_action(null);
        break;

    // admin actions
    case 'admin_post':
        require 'admin/actions/post_action.php';
        $action = new post_action("post.html");
        break;

    case 'admin_posts':
        require 'admin/actions/posts_action.php';
        $action = new posts_action("posts.html");
        break;

    case 'admin_page':
        require 'admin/actions/page_action.php';
        $action = new page_action("page.html");
        break;

    case 'admin_pages':
        require 'admin/actions/pages_action.php';
        $action = new pages_action("pages.html");
        break;

    case 'admin_comment':
        require 'admin/actions/comment_action.php';
        $action = new comment_action("comment.html");
        break;

    case 'admin_comments':
        require 'admin/actions/comments_action.php';
        $action = new comments_action("comments.html");
        break;

    case 'admin_category':
        require 'admin/actions/category_action.php';
        $action = new category_action("category.html");
        break;

    case 'admin_categories':
        require 'admin/actions/categories_action.php';
        $action = new categories_action("categories.html");
        break;

    case 'admin_user':
        require 'admin/actions/user_action.php';
        $action = new user_action("user.html");
        break;

    case 'admin_users':
        require 'admin/actions/users_action.php';
        $action = new users_action("users.html");
        break;
}

// execute action
if ($action != null && $action->prepare())
    $action->execute();
else if ($_GET['action'] != 'error') // prevent infinite loop when 'error' action gets errors
    header("Location: dispatch.php?action=page&id=3");

?>