<?php

// include files
require_once(WEB_ROOT . '/web.config');
require_once(WEB_ROOT . '/install/database/sql.php');

require_once(WEB_ROOT . '/utilities/common.php');
require_once(WEB_ROOT . '/utilities/weblate.php');
require_once(WEB_ROOT . '/utilities/database.php');
require_once(WEB_ROOT . '/data_access/user_access.php');

// declare class
class blog_settings_action
{
    private $theme_file;
    private $weblate;
    
    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        session_start();
        $this->theme_file = $theme_file;
        $this->weblate = new weblate(WEB_ROOT . "/install", "theme");
    }

    // destructor
    public function __destruct()
    {
        unset($this->theme_file);
        unset($this->weblate);
    }
    
    // save user's settings
    private function save_settings()
    {
        $content = common::get_file_content(WEB_ROOT . "/web.config");
        if ($content != null)
        {
            $content = common::change_config_item($content, "DATABASE_SERVER", $_SESSION["DATABASE_SERVER"]);
            $content = common::change_config_item($content, "DATABASE_USER", $_SESSION["DATABASE_USER"]);
            $content = common::change_config_item($content, "DATABASE_PASSWORD", $_SESSION["DATABASE_PASSWORD"]);
            $content = common::change_config_item($content, "DATABASE_NAME", $_SESSION["DATABASE_NAME"]);
            
            $content = common::change_config_item($content, "BLOG_TITLE", $_SESSION["BLOG_TITLE"]);
            $content = common::change_config_item($content, "BLOG_DESCRIPTION", $_SESSION["BLOG_DESCRIPTION"]);
            $content = common::change_config_item($content, "BLOG_KEYWORDS", $_SESSION["BLOG_KEYWORDS"]);
            
            file_put_contents(WEB_ROOT . "/web.config", $content);
        }
        else
        {
            $_SESSION["INSTALL_MESSAGE"] = "不能获取web.config文件的内容。";
        }
    }
    
    // initialize database
    private function init_database()
    {
        // create tables and insert some initialize data
        global $sqls;
        foreach ($sqls as $sql)
        {
            database::get_instance()->execute_sql($sql);
        }
        
        // update user information
        $user = user_access::get_user(1);
        if ($user != null)
        {
            $user["name"] = $_SESSION["LOGIN_USER"];
            $user["password"] = md5($_SESSION["LOGIN_PASSWORD"]);
            user_access::update_user(1, $user);
            
            $_SESSION["INSTALL_MESSAGE"] = "恭喜，Wepress数据库安装及系统初始化成功。";
        }
        else
        {
            $_SESSION["INSTALL_MESSAGE"] = "不能获取默认的管理员用户信息。";
        }
    }

    // prepare action
    // returns: true if prepare successful, otherwise false
    public function prepare()
    {
        if ($_SERVER['REQUEST_METHOD'] == "GET")
        {
            if ($_SESSION["LOGIN_USER"] == null)
                $_SESSION["LOGIN_USER"] = "admin";
        }
        else if ($_POST['ACTION'] == "INSTALL")
        {
            $_SESSION["BLOG_TITLE"] = $_POST['BLOG_TITLE'];
            $_SESSION["BLOG_DESCRIPTION"] = $_POST['BLOG_DESCRIPTION'];
            $_SESSION["BLOG_KEYWORDS"] = $_POST['BLOG_KEYWORDS'];
            $_SESSION["LOGIN_USER"] = $_POST['LOGIN_USER'];
            $_SESSION["LOGIN_PASSWORD"] = $_POST['LOGIN_PASSWORD'];
            $_SESSION["RETYPE_LOGIN_PASSWORD"] = $_POST['RETYPE_LOGIN_PASSWORD'];
            
            // save settings
            $this->save_settings();
            
            // initialize database
            $this->init_database();
            
            // redirect to finish page
            common::redirect_page("setup.php?action=finish");
        }
        return true;
    }

    // execute action
    public function execute()
    {
        if ($this->weblate->load($this->theme_file) != null)
        {
            // assign variables
            $this->weblate->assign("BLOG_TITLE", $_SESSION["BLOG_TITLE"]);
            $this->weblate->assign("BLOG_DESCRIPTION", $_SESSION["BLOG_DESCRIPTION"]);
            $this->weblate->assign("BLOG_KEYWORDS", $_SESSION["BLOG_KEYWORDS"]);
            $this->weblate->assign("LOGIN_USER", $_SESSION["LOGIN_USER"]);
            $this->weblate->assign("LOGIN_PASSWORD", $_SESSION["LOGIN_PASSWORD"]);
            $this->weblate->assign("RETYPE_LOGIN_PASSWORD", $_SESSION["RETYPE_LOGIN_PASSWORD"]);

            // compile theme and show it
            $this->weblate->compile();
            $this->weblate->show();
        }
    }
}

?>