<?php

// include files
require_once(WEB_ROOT . '/utilities/common.php');
require_once(WEB_ROOT . '/utilities/weblate.php');

// declare class
class database_settings_action
{
    private $theme_file;
    private $weblate;
    
    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        session_start();
        $this->theme_file = $theme_file;
        $this->weblate = new weblate(WEB_ROOT . "/install", "theme");
    }

    // destructor
    public function __destruct()
    {
        unset($this->theme_file);
        unset($this->weblate);
    }

    // prepare action
    // returns: true if prepare successful, otherwise false
    public function prepare()
    {
        if ($_SERVER['REQUEST_METHOD'] == "GET")
        {
            if ($_SESSION["DATABASE_SERVER"] == null)
                $_SESSION["DATABASE_SERVER"] = "localhost:3306";
        }
        else if ($_POST["ACTION"] == "NEXT")
        {
            // save database settings
            $_SESSION["DATABASE_SERVER"] = $_POST['DATABASE_SERVER'];
            $_SESSION["DATABASE_USER"] = $_POST['DATABASE_USER'];
            $_SESSION["DATABASE_PASSWORD"] = $_POST['DATABASE_PASSWORD'];
            $_SESSION["DATABASE_NAME"] = $_POST['DATABASE_NAME'];
            
            // redirect page to blog settings
            common::redirect_page("setup.php?action=blog_settings");
        }
        return true;
    }

    // execute action
    public function execute()
    {
        if ($this->weblate->load($this->theme_file) != null)
        {
            // assign variables
            $this->weblate->assign("DATABASE_SERVER", $_SESSION["DATABASE_SERVER"]);
            $this->weblate->assign("DATABASE_USER", $_SESSION["DATABASE_USER"]);
            $this->weblate->assign("DATABASE_PASSWORD", $_SESSION["DATABASE_PASSWORD"]);
            $this->weblate->assign("DATABASE_NAME", $_SESSION["DATABASE_NAME"]);

            // compile theme and show it
            $this->weblate->compile();
            $this->weblate->show();
        }
    }
}

?>