<?php

// include files
require_once(WEB_ROOT . '/utilities/common.php');
require_once(WEB_ROOT . '/utilities/weblate.php');

// declare class
class finish_action
{
    private $theme_file;
    private $weblate;
    
    // constructor
    // $theme_file: theme file name
    public function __construct($theme_file)
    {
        session_start();
        $this->theme_file = $theme_file;
        $this->weblate = new weblate(WEB_ROOT . "/install", "theme");
    }

    // destructor
    public function __destruct()
    {
        unset($this->theme_file);
        unset($this->weblate);
    }

    // prepare action
    // returns: true if prepare successful, otherwise false
    public function prepare()
    {
        if ($_SERVER['REQUEST_METHOD'] == "POST")
        {
            common::redirect_page("../index.php");
        }
        return true;
    }

    // execute action
    public function execute()
    {
        if ($this->weblate->load($this->theme_file) != null)
        {
            // assign variables
            $this->weblate->assign("INSTALL_MESSAGE", $_SESSION["INSTALL_MESSAGE"]);

            // compile theme and show it
            $this->weblate->compile();
            $this->weblate->show();
        }
    }
}

?>