<?php

$sqls = array();

// create tables
$sqls[0] = "CREATE TABLE `categories` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `parent_id` int(11) NOT NULL,
          `name` varchar(50) NOT NULL,
          `display_order` int(11) NOT NULL,
          `description` varchar(200) DEFAULT NULL,
          `post_count` int(11) NOT NULL DEFAULT '0',
          `meta` text,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;";

$sqls[1] = "CREATE TABLE `comments` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `post_id` int(11) DEFAULT NULL,
          `content` text NOT NULL,
          `status` tinyint(4) NOT NULL DEFAULT '1',
          `replier_name` varchar(50) DEFAULT NULL,
          `replier_email` varchar(100) DEFAULT NULL,
          `replier_url` varchar(100) DEFAULT NULL,
          `replier_ip` varchar(15) NOT NULL,
          `create_time` datetime NOT NULL,
          `meta` text,
          PRIMARY KEY (`id`),
          KEY `FK_Reference_1` (`post_id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;";

$sqls[2] = "CREATE TABLE `options` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `name` varchar(256) DEFAULT NULL,
          `value` varchar(256) DEFAULT NULL,
          `group` varchar(50) DEFAULT NULL,
          `display_order` int(11) DEFAULT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;";

$sqls[3] = "CREATE TABLE `post_category_relationships` (
          `post_id` int(11) NOT NULL,
          `category_id` int(11) NOT NULL,
          `is_direct` tinyint(4) NOT NULL DEFAULT '0'
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";

$sqls[4] = "CREATE TABLE `posts` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `user_id` int(11) NOT NULL,
          `title` varchar(100) NOT NULL,
          `summary` text,
          `content` text NOT NULL,
          `status` tinyint(4) NOT NULL DEFAULT '1',
          `type` tinyint(4) NOT NULL DEFAULT '1',
          `sticky` tinyint(4) NOT NULL DEFAULT '0',
          `open_comment` tinyint(1) NOT NULL DEFAULT '1',
          `tags` varchar(100) DEFAULT NULL,
          `read_count` int(11) NOT NULL DEFAULT '0',
          `comment_count` int(11) NOT NULL DEFAULT '0',
          `create_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
          `update_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
          `meta` text,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 AVG_ROW_LENGTH=616;";

$sqls[5] = "CREATE TABLE `users` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `name` varchar(50) DEFAULT NULL,
          `password` varchar(50) NOT NULL,
          `sex` tinyint(4) DEFAULT NULL,
          `email` varchar(100) DEFAULT NULL,
          `url` varchar(100) DEFAULT NULL,
          `register_time` datetime DEFAULT NULL,
          `meta` text,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 AVG_ROW_LENGTH=8192;";

// insert initialize data
$sqls[6] = "INSERT INTO `categories` (`id`, `parent_id`, `name`, `display_order`, `description`, `post_count`, `meta`) VALUES 
    (0,-1,'根',0,'所有分类的根',1,NULL);";
    
$sqls[7] = "UPDATE `categories` SET id = 0 WHERE parent_id = -1";

$sqls[8] = "INSERT INTO `categories` (`id`, `parent_id`, `name`, `display_order`, `description`, `post_count`, `meta`) VALUES 
    (1,0,'默认分类',1,'默认的日志分类',1,'');";

$sqls[9] = "INSERT INTO `comments` (`id`, `post_id`, `content`, `status`, `replier_name`, `replier_email`, `replier_url`, `replier_ip`, `create_time`, `meta`) VALUES 
    (2,4,'这是一篇简要介绍Wepress的文章，您在成功搭建博客后，可以通过后台管理将其删除。',1,'游客','','','127.0.0.1',now(),'');";

$sqls[10] = "INSERT INTO `options` (`id`, `name`, `value`, `group`, `display_order`) VALUES 
    (1,'Wepress，开源博客系统','http://www.wepress.cn','1',1);";

$sqls[11] = "INSERT INTO `post_category_relationships` (`post_id`, `category_id`, `is_direct`) VALUES 
    (4,1,1), 
    (4,0,0);";

$sqls[12] = "INSERT INTO `posts` (`id`, `user_id`, `title`, `summary`, `content`, `status`, `type`, `sticky`, `open_comment`, `tags`, `read_count`, `comment_count`, `create_time`, `update_time`, `meta`) VALUES 
    (1,1,'关于我','','&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 您可以编辑本页面，介绍关于您本人或本网站的一些信息，使读者对您及本站有个大体的了解。',1,0,-1,1,'',0,0,now(),now(),''),
    (2,1,'给我留言','','首先，我不能解答您提出的所有问题，但我会竭尽全力。<br />\r\n其次，有事可以在此给我留言，或者发送Email给我：<a href=\"mailto:myname@domain.com\">myname@domain.com</a>',1,0,-1,1,'',0,0,now(),now(),''),
    (3,1,'系统错误','','对不起，当前系统产生了错误，给您带来的不便深感抱歉，导致错误出现的原因如下：<br />\r\n1、您所访问的页面不存在，或已被系统管理员删除<br />\r\n2、您没有权限访问该页面<br />\r\n3、由于系统内部逻辑问题导致的系统异常<br />\r\n',1,0,-1,0,'',0,0,now(),now(),''),
    (4,1,'关于Weress','','<span style=\"color: rgb(0, 0, 128);\"><strong><span style=\"font-family: arial,helvetica,sans-serif;\">Wepress</span></strong> </span>是一款简单、易用、设计优雅的博客系统，您可以使用它来快速搭建个性化的博客、信息发布等平台。<br />\r\n<br />\r\n<div style=\"line-height: 200%;\">\r\n\tWepress虽然设计小巧，但它仍然具有以下诸多特点：<br />\r\n\t1、<u><span style=\"color: rgb(0, 0, 128);\">内置一款小巧的模板引擎</span></u><br />\r\n\t&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 自带了一个小巧的模板引擎，同时定义了一套简洁、优美的模板语法<br />\r\n\t2、<u><span style=\"color: rgb(0, 0, 128);\">可简单、灵活地自定义所需模板</span></u><br />\r\n\t&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 使用HTML文件作为页面模板，借助模板引擎提高的各种语法，使代码和页面完美分离，模板制作更加简单<br />\r\n\t3、<u><span style=\"color: rgb(0, 0, 128);\">支持插件、易于扩展程序功能</span></u><br />\r\n\t&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 灵活的插件机制，可方便的扩展程序功能<br />\r\n\t4、<u><span style=\"color: rgb(0, 0, 128);\">支持多用户</span></u><br />\r\n\t&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 可同时允许多个用户发布及管理网站信息<br />\r\n\t5、<u><span style=\"color: rgb(0, 0, 128);\">跨平台支持</span></u><br />\r\n\t&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Wepress是基于PHP和MySQL开发的，因此具有原生的跨平台特性，可支持Windows、Linux等主流操作系统平台</div>\r\n',1,1,0,1,'Wepress',1,1,now(),now(),'');";

$sqls[13] = "INSERT INTO `users` (`id`, `name`, `password`, `sex`, `email`, `url`, `register_time`, `meta`) VALUES 
    (1,'admin','eb2018a6ef1db11a7a4ddde49d52a11d',1,'myname@domain.com','www.mydomain.com',now(),'');";
?>