<?php

// declare class
class api
{
    // calculate the next character pointer from current
    // $string: string to find
    // $pointer: current pointer
    // returns: the next character pointer
    private static function next_char_pointer($string, $pointer)
    {
        $char = ord(substr($string, $pointer, 1));
        if ($char > 224)
            return $pointer + 0x03;
        elseif ($char > 192 && $char < 224)
            return $pointer + 0x02;
        else
            return $pointer + 0x01;
    }

    // calculate string length
    // $string: string to calucate
    // returns: the length of string
    public static function strlen2($string)
    {
        $length = 0;

        $pointer = 0;
        $origin_length = strlen($string);
        while ($pointer < $origin_length)
        {
            $pointer = self::next_char_pointer($string, $pointer);
            $length += 1;
        }

        return $length;
    }

    // an extension method for substr
    // $string: string to get
    // $start: start index, based on zero
    // $length: length to cut
    // returns: sub-stirng
    public static function substr2($string, $start, $length)
    {
        $from = 0;
        for ($i = 0; $i < $start; $i++)
        {
            $from = self::next_char_pointer($string, $from);
        }

        $to = $from;
        for ($i = 0; $i < $length; $i++)
        {
            $to = self::next_char_pointer($string, $to);
        }

        return substr($string, $from, $to - $from);
    }

    // format datetime
    // $time: time string to get
    // $pattern: pattern of time string
    // returns: datetime string
    public static function format_time($time, $pattern = 'Y/m/d H:i')
    {
        return date($pattern, strtotime($time));
    }

    // convert string to 3 points on ending
    // $string: string to convert
    // $truncate_length: truncate length
    // returns: converted string
    public static function to_3points($string, $truncate_length)
    {
        if (self::strlen2($string) > $truncate_length)
        {
            $string = self::substr2($string, 0x00, $truncate_length) . "...";
        }
        return $string;
    }

    // is string empty?
    // $string: string to test
    // returns: true if string is null or empty or only contains white spaces, otherwise false
    public static function is_string_empty($string)
    {
        return ($string == null || trim($string) == '');
    }

    // get gravatar url
    // $email: email address
    // $width: image width
    // returns: gravatar url
    public static function get_gravatar_url($email, $width)
    {
        $pattern = "http://www.gravatar.com/avatar/%s?d=identicon&s=%d&r=g";
        return sprintf($pattern, md5($email), $width);
    }
}

?>