<?php

// include files
require_once(WEB_ROOT . '/utilities/api.php');

// declare class
class common
{
    // redirect page to another
    // $url: page url to redirect
    public static function redirect_page($url)
    {
        header("Location: $url");
        exit();
    }

    // get theme root
    // $is_admin_theme: is admin theme ?
    // returns: theme root
    public static function get_theme_root($is_admin_theme)
    {
        return $is_admin_theme ? 
            sprintf("%s/%s", ADMIN_THEME_ROOT, ADMIN_THEME_NAME) : 
            sprintf("%s/%s", THEME_ROOT, THEME_NAME);
    }

    // get file relative url (relative to site root)
    // $file_path: file full path
    // returns: file url
    public static function get_file_url($file_path)
    {
        return substr($file_path, strlen(WEB_ROOT) + 1);
    }

    // get file content
    // $file_path : file full path
    // return : file content
    public static function get_file_content($file_path)
    {
        if (file_exists($file_path))
        {
            return file_get_contents($file_path);
        }
        return null;
    }
    
    // split custom text
    // $text: text to split
    // returns: matches sections
    public static function split_custom_text($text)
    {
        $pattern = '/{\s*([^:|\s]+)\s*:\s*([^}|\s]+)\s*}/i';
        if (preg_match_all($pattern, $text, $matches, PREG_SET_ORDER) != false)
        {
            return $matches;
        }
        return null;
    }

    // attach meta sections (such as "{path:/images/}{icon:logo.gif}...") into row
    // $row: data row
    // returns: data row with meta sections
    public static function attach_meta_values_into_row($row)
    {
        // valid meta string
        if (!api::is_string_empty($row['meta']))
        {
            // make regex pattern and match it
            $matches = self::split_custom_text($row['meta']);
            if ($matches != null)
            {
                // attach meta sections as array elements
                for ($i = 0; $i < count($matches); $i++)
                {
                    $row[$matches[$i][1]] = $matches[$i][2];
                }
            }
        }
        return $row;
    }
    
    // attach meta sections (such as "{path:/images/}{icon:logo.gif}...") into rows
    // $row: data rows
    // returns: data rows with meta sections
    public static function attach_meta_values_into_rows($rows)
    {
        for ($i = 0; $i < count($rows); $i++)
        {
            $row = $rows[$i];
            $rows[$i] = self::attach_meta_values_into_row($row, $row['meta']);
        }
        return $rows;
    }
    
    // make a config item string
    // $name: config item name
    // $value: config item value
    // $delimeter: delimeter on the ending of value
    // returns: a config item string
    public static function make_config_item($name, $value, $delimeter)
    {
        return sprintf("\"%s\", %s%s%s);", $name, $delimeter, $value, $delimeter);
    }
    
    // change config item value
    // $content: config file content
    // $name: config item name
    // $value: config item value
    // $delimeter: delimeter on the ending of value
    // returns: new config file content
    public static function change_config_item($content, $name, $value, $delimeter='"')
    {
        $pattern = sprintf('/\\\*[\"\']%s\\\*[\"\']\s*,\s*\\\*[\"\']*[^\r]+/e', $name);
        return preg_replace($pattern, "common::make_config_item('$name', '$value', '$delimeter');", $content);
    }
}

?>