<?php

// description: a helper class to handle database
//      author: fanwensheng
//         msn: fanwensheng@live.com
//     address: hefei, anhui province
//   copyright: 2009~2010 all rights reserved

// declare class
class database
{
    private $connection;
    private static $instance;

    // destructor
    public function __destruct()
    {
        @mysql_close($this->connection);
        unset($this->connection);
        self::$instance = null;
    }

    // get database instance
    // returns: database instance
    public static function get_instance()
    {
        if (self::$instance == null)
        {
            self::$instance = new database();
            self::$instance->connect();
        }
        return self::$instance;
    }
    
    // connect to database
    private function connect()
    {
        $this->connection = @mysql_connect(DATABASE_SERVER, DATABASE_USER, DATABASE_PASSWORD);
        @mysql_query("SET NAMES 'utf8'", $this->connection);
        @mysql_select_db(DATABASE_NAME, $this->connection);
    }

    // escapes characters to be mysql ready
    // $string: string to escape
    // returns: escaped string
    private function escape($string)
    {
        if(get_magic_quotes_gpc())
        {
            $string = stripslashes($string);
        }
        return mysql_real_escape_string($string);
    }

    // query records
    // $sql: sql statement
    // returns: records
    public function query_records($sql)
    {
        $records = array();

        $result = @mysql_query($sql, $this->connection);
        while ($record = @mysql_fetch_assoc($result))
        {
            $records[] = $record;
        }
        @mysql_free_result($result);

        return $records;
    }
    
    // query the first record
    // $sql: sql statement
    // returns: the first record
    public function query_first_record($sql)
    {
        $records = $this->query_records($sql);
        return count($records) > 0 ? $records[0] : null;
    }
    
    // query scalar
    // $sql: sql statement
    // returns: scalar number
    public function query_scalar($sql)
    {
        $record = $this->query_first_record($sql);
        return @intval($record['scalar']);
    }

    // query insert
    // $table_name: table name
    // $data: data to insert
    // returns: record id if successful, otherwise 0
    public function query_insert($table_name, $data)
    {
        // sql pattern
        $pattern = "insert into %s (%s) values (%s)";
        
        // make field string and value string
        $fields = '';
        $values = '';
        foreach($data as $key=>$value)
        {
            $fields .= sprintf("`%s`, ", $key);
            if(strtolower($value) == 'null')
                $values .= "null, ";
            else if(strtolower($value)=='now()')
                $values .= "now(), ";
            else
                $values .= sprintf("'%s', ", $this->escape($value));
        }
        
        // make sql statement and execute it
        $sql = sprintf($pattern, $table_name, rtrim($fields, ', '), rtrim($values, ', '));
        return ($this->execute_sql($sql) > 0) ? mysql_insert_id() : 0;
    }

    // query update
    // $table_name: table name
    // $data: data to update
    // $where: where clause
    // returns: affected row count
    public function query_update($table_name, $data, $where = '1')
    {
        // sql pattern
        $pattern = "update %s set %s where %s";
        
        // make field string and value string
        $fields = '';
        foreach($data as $key=>$value)
        {
            if(strtolower($value) == 'null')
                $fields .= sprintf('%s = null, ', $key);
            else if(strtolower($value)=='now()')
                $fields .= sprintf('%s = now(), ', $key);
            else
                $fields .= sprintf("%s = '%s', ", $key, $this->escape($value));
        }

        // make sql statement and execute it
        $sql = sprintf($pattern, $table_name, rtrim($fields, ', '), $where);
        return $this->execute_sql($sql);
    }
    
    // execute sql statement
    // $sql: sql statement
    // returns: affected row count
    public function execute_sql($sql)
    {
        @mysql_query($sql, $this->connection);
        return @mysql_affected_rows($this->connection);
    }
}

?>