<?php

class pagination
{
    const PAGINATION_ITEM_COUNT = 0x0a;

    // defines variables
    private $item_total_count;
    private $item_count_per_page;

    public $current_page;
    public $last_page;

    // constructor
    public function __construct()
    {
        $this->current_page = 0x01;
        $this->last_page = 0x01;
    }

    // destructor
    public function __destruct()
    {
        unset($this->item_total_count);
        unset($this->item_count_per_page);
        
        unset($this->current_page);
        unset($this->last_page);
    }

    // get previous page
    // returns: previous page index
    private function get_previous_page()
    {
        $page = $this->current_page - 1;
        return ($page < 1) ? 1 : $page;
    }
    
    // get next page
    // returns: next page index
    private function get_next_page()
    {
        $page = $this->current_page + 1;
        $last = $this->get_last_page();
        return ($page > $last) ? $last: $page;
    }

    // get last page
    // returns: last page index
    private function get_last_page()
    {
        return @intval(ceil($this->item_total_count / $this->item_count_per_page));
    }

    // get from page index
    // returns: from page index
    private function get_from_page()
    {
        $page = $this->current_page - floor(self::PAGINATION_ITEM_COUNT / 2);
        
        $last_page = $this->get_last_page();
        if ($last_page - $page + 1 < self::PAGINATION_ITEM_COUNT)
        {
            $page = $last_page - self::PAGINATION_ITEM_COUNT + 1;
        }
        
        return ($page < 1) ? 1 : @intval($page);
    }
    
    // get to page index
    // returns: to page index
    private function get_to_page()
    {
        $page = $this->get_from_page() + self::PAGINATION_ITEM_COUNT - 1;
        $last_page = $this->get_last_page();
        return ($page > $last_page) ? $last_page : $page;
    }

    // prepare pagination
    // $item_total_count: item total count
    // $item_count_per_page: item count per page
    // returns: always true
    public function prepare($item_total_count, $item_count_per_page)
    {
        // save variables
        $this->item_total_count = $item_total_count;
        $this->item_count_per_page = $item_count_per_page;

        // get current page index and last page, based on 1
        $this->current_page = @intval($_GET['page']);
        $this->last_page = $this->get_last_page();

        // recalcute the current page index, based on 1
        if ($this->current_page < 0x01)
            $this->current_page = 0x01;
        else if ($this->current_page > $this->last_page)
            $this->current_page = $this->last_page;

        return true;
    }

    // assign data to weblate::vars
    // $weblate: weblate instance
    public function assign($weblate)
    {
        $from_page = $this->get_from_page();
        $to_page = $this->get_to_page();
        $previous_page = $this->get_previous_page();
        $next_page = $this->get_next_page();

        $weblate->assign("from_page", $from_page);
        $weblate->assign("to_page", $to_page);
        $weblate->assign("current_page", $this->current_page);
        $weblate->assign("previous_page", $previous_page);
        $weblate->assign("next_page", $next_page);
        $weblate->assign("last_page", $this->last_page);
        $weblate->assign("item_total_count", $this->item_total_count);
    }
}

?>