<?php

// declare class
class plugin
{
    // hooks array
    private static $hooks = array();

    // load all active plugins
    public static function load_active_plugins()
    {
        // split custom text
        $matches = common::split_custom_text(ACTIVE_PLUGINS);
        if ($matches != null)
        {
            // include active plugins
            for ($i = 0; $i < count($matches); $i++)
                @include_once(WEB_ROOT . sprintf('/plugins/%s', $matches[$i][2]));
        }
    }

    // register a function to hook
    // $hook: hook name
    // $function: function name
    public static function register($hook, $function)
    {
        self::$hooks[$hook][$function] = array("function" => $function);
    }

    // trigger a hook, this method supports multiple extention parameters that to call user's function with them
    // $hook: hook name
    // $params: parameters array to call function(plugin)
    public static function trigger($hook /*, param1, param2, param3, ...*/)
    {
        // get all plugins under a special hook
        $plugins = self::$hooks[$hook];
        if (isset($plugins) && is_array($plugins) && count($plugins) > 0)
        {
            // put parameters into an array
            $params = array();
            for ( $i = 1; $i < func_num_args(); $i++ )
                $params[] = func_get_arg($i);

            // invoke plugin functions
            foreach ($plugins as $plugin)
            {
                if (!is_null($plugin['function']))
                    call_user_func_array($plugin['function'], $params);
            }
        }
    }
}

?>