<?php

// description: this is a mini template engine, 
//              its only take some normally functions such as 'if', 'else', 'foreach' and etc.,
//              i written it for my 'wepress' project, 
//              that's it.
//     version: 1.1.1.0
//      author: fanwensheng
//         msn: fanwensheng@live.com
//     address: hefei, anhui province
//   copyright: 2009-2010 all rights reserved

// declare class
class weblate
{
    private $vars;
    private $content;
    
    // for example, there is a theme file with full path 'd:\programs\wepress\root\themes\default\post.html', then:
    // the web root is 'd:\programs\wepress\root',
    // the theme path is 'themes\default'
    private $web_root;
    private $theme_path;

    // private constructor
    // $web_root: web site root path
    // $theme_path: theme path
    public function __construct($web_root, $theme_path)
    {
        $this->vars= array();
        $this->content = null;

        $this->web_root = rtrim($web_root, "\\/");
        $this->theme_path = trim($theme_path, "\\/");
    }

    // default destructor
    public function __destruct()
    {
        unset($this->vars);
        unset($this->content);
        unset($this->working_directory);
    }

    // a callback function to zip page content
    // $content: content to zip
    // returns: ziped content
    private function gzip($content)
    {
        if(!headers_sent() && extension_loaded("zlib") && strstr($_SERVER["HTTP_ACCEPT_ENCODING"], "gzip"))
        {
            $content = gzencode($content, 9);

            header("Content-Encoding: gzip");
            header("Vary: Accept-Encoding");
            header("Content-Length: " . strlen($content));
        }
        return $content;
    }

    // get file full path
    // $file_name: relative to theme root
    // returns: file full path
    private function get_file_path($file_name)
    {
        $url = $this->get_file_url($file_name);
        return sprintf("%s/%s", $this->web_root, $url);
    }
    
    // get file url
    // $file_name: relative to theme root
    // returns: file url
    private function get_file_url($file_name)
    {
        return sprintf("%s/%s", $this->theme_path, $file_name);
    }

    // load template file
    // $file_name: relative to theme root
    // returns: true if successfully, false otherwise
    public function load($file_name)
    {
        $path = $this->get_file_path($file_name);
        $this->content = common::get_file_content($path);
        $this->content = $this->merge_include($this->content);
        return ($this->content != null);
    }
    
    // assign a value to a variable
    // $name: variable's name
    // $value: variable's value
    public function assign($name, $value)
    {
        if ($name != '')
        {
            $this->vars[$name] = $value;
        }
    }
    
    // get value by name
    // $name: name to get value
    // returns: the value
    public function get($name)
    {
        return $this->vars[$name];
    }

    // compile template
    public function compile()
    {
        // decode tokens
        $pattern = "/{(\s*[a-zA-Z\_\#\$\/]\w*)(\s*[\x20-\x7a\|\~]*)}/e";
        $this->content = preg_replace($pattern, "\$this->decode_token('\\1', '\\2');", $this->content);

        // correct path for js, css, image and input(submit button with image)
        $pattern = "/<\s*(link|script|img|input)\s+([^\>]+)>/e";
        $this->content = preg_replace($pattern, "\$this->correct_path('\\1', '\\2');", $this->content);
    }

    // show template
    public function show()
    {
        // turn on output buffering for zip page content
        if (ENABLE_GZIP)
            ob_start(array('weblate', 'gzip'));

        // show page content
        eval('?' . '>' . trim($this->content));

        // output buffer
        if (ENABLE_GZIP)
            ob_end_flush();
    }

    // inner function for merge include
    // $express: include expression
    // returns: merged content
    private function inner_merge_include($express)
    {
        $pattern = '/\w+\s*=\s*\\\"*\\\'*\s*[^\"\']+\s*\\\"*\\\'*/';
        if (preg_match_all($pattern, $express, $matches, PREG_SET_ORDER) != false)
        {
            $parameters = ''; $content = '';
            for ($i = 0; $i < count($matches); $i++)
            {
                $index = strpos($matches[$i][0], '=');
                if ($index != false)
                {
                    $name = trim(substr($matches[$i][0], 0, $index));
                    $value = trim(substr($matches[$i][0], $index + 1), "\"\'");

                    if (strtolower($name) == 'file')
                        $content = common::get_file_content($this->get_file_path($value));
                    else
                        $parameters .= sprintf("<?php $%s=%s; ?>", $name, $this->base_decode($value));
                }
            }
            return $parameters . $content;
        }
    }

    // merge file for 'include' tags
    // $content: content to merge
    // returns: merged content
    private function merge_include($content)
    {
        $pattern = "/{\s*include\s+([^}]+)}/e";
        return preg_replace($pattern, "\$this->inner_merge_include('\\1')", $content);
    }

    // decode token
    // $name: raw name
    // $value: raw value
    // returns: a string in php or html syntax
    private function decode_token($raw_name, $raw_value)
    {
        // trim spaces on endings
        $name = str_replace("\\", "", trim($raw_name));
        $value = str_replace("\\", "", trim($raw_value));

        // do decoding...
        if ($name{0} == '#' || $name{0} == '$')
        {
            // example: {#name}, {#name.first_name}
            $expression = $this->base_decode($raw_name . $raw_value);
            return sprintf("<?php echo %s; ?>", $expression);
        }
        elseif ($name == "if")
        {
            // example: {if $name != null}
            $expression = $this->base_decode($value);
            return sprintf("<?php if (%s) { ?>", str_replace("\\", "", $expression));
        }
        elseif ($name == "else")
        {
            // example: {else}
            return '<?php } else { ?>';
        }
        elseif ($name == "elseif")
        {
            // example: {elseif $name != null}
            $expression = $this->base_decode($value);
            return sprintf("<?php } elseif (%s) { ?>", str_replace("\\", "", $expression));
        }
        elseif ($name == "/if")
        {
            // example: {/if}
            return '<?php } ?>';
        }
        elseif ($name == "for")
        {
            // example: {for @i = 0; @i < 100; @i++}
            $expression = $this->base_decode($value);
            return sprintf("<?php for (%s) { ?>", $expression);
        }
        elseif ($name == "/for")
        {
            // example: {/for}
            return sprintf('<?php } ?>');
        }
        elseif ($name == "foreach")
        {
            // example: {foreach $students as @key=>@value}
            $expression = $this->base_decode($value);

            // make trace expression
            $array = substr($expression, 0, strpos($expression, " "));
            $trace = sprintf("\$this->vars['last_index'] = count(%s) - 1;\$this->vars['current_index'] = 0;", $array);

            // begin foreach statement
            return sprintf("<?php %s foreach (%s) { ?>", $trace, str_replace("\\", "", $expression));
        }
        elseif ($name == "/foreach")
        {
            // example: {/foreach}
            $trace = "\$this->vars['current_index'] += 1;";
            return sprintf('<?php %s } ?>', $trace);
        }
        elseif ($name == "css")
        {
            // example: {css 'stylesheet.css'}
            $value = trim($value, "\',\", ");
            return sprintf("<link rel='stylesheet' type='text/css' href='%s' />", $value);
        }
        elseif ($name == "js")
        {
            // example: {js 'javascript.js'}
            $value = trim($value, "\',\", ");
            return sprintf("<script type='text/javascript' src='%s'></script>", $value);
        }
        elseif ($name == "api")
        {
            // example: {api format_time('xxx')}
            $expression = $this->base_decode($value);
            return sprintf("<?php echo api::%s; ?>", $expression);
        }
        elseif ($name == "plugin")
        {
            // example: {plugin 'post_header'}
            $value = trim($value, "\',\", ");
            return sprintf("<?php plugin::trigger('%s', \$this); ?>", $value);
        }
        elseif ($name == "code")
        {
            // example: {code $name='wensheng'}, {code api::format_time($post.update_time)}
            $expression = $this->base_decode($value);
            return sprintf("<?php %s; ?>", $expression);
        }
        return sprintf('{%s %s}', $name, $value);
    }

    // basic decode
    // $token_string: token string
    // returns: an express with php syntax
    private function base_decode($token_string)
    {
        // for '#' token
        $pattern = "/\#(\w+)/";
        $token_string = preg_replace($pattern, "\$this->vars['\\1']", $token_string);

        // for '.' token
        $pattern = "/\.(\w+)/";
        return preg_replace($pattern, "['\\1']", $token_string);
    }

    // correct path
    // $name: raw name
    // $value: raw value
    // returns: a images/input/js/css tag with valid path
    private function correct_path($name, $value)
    {
        $pattern = '/(href|src)\s*=\s*\\\*[\"\']\s*([\w\.\/\-]+)\s*\\\*[\"\']/e';
        $value = str_replace("\\", "", preg_replace($pattern, "sprintf(\"%s='%s'\", '\\1', \$this->get_file_url('\\2'));", $value));

        if ($name == "img")
        {
            return sprintf("<img %s>", $value);
        }
        elseif ($name == "link")
        {
            return sprintf("<link %s>", $value);
        }
        elseif($name == "script")
        {
            return sprintf("<script %s>", $value);
        }
        elseif ($name == "input")
        {
            return sprintf("<input %s>", $value);
        }
        
        // keep original text
        return sprintf("<%s %s>", $name, $value);
    }
}

?>